<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('testimonial'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_testimonial'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('frontend/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">

                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(EDIT, 'frontend', 'testimonial')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-quote-left font-30 mr-10"></i>
                            <?php echo $this->lang->line('edit'); ?> <?php echo $this->lang->line('testimonial'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'frontend', 'testimonial')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('frontend/testimonial'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('testimonial'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('frontend/testimonial/edit/' . $testimonial->id), array('name' => 'edit', 'id' => 'edit', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-3 mb-10">
                            <label for="name"><?php echo $this->lang->line('name'); ?></label>
                            <input type="text" class="form-control" name="name" id="name" value="<?php echo isset($testimonial->name) ?  $testimonial->name : ''; ?>" placeholder="<?php echo $this->lang->line('name'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('name'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="bn_name"><?php echo $this->lang->line('bn_name'); ?></label>
                            <input type="text" class="form-control" name="bn_name" id="bn_name" value="<?php echo isset($testimonial->bn_name) ?  $testimonial->bn_name : ''; ?>" placeholder="<?php echo $this->lang->line('bn_name'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="bn_name" class="form-text text-muted">
                                <?php echo form_error('bn_name'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="company"><?php echo $this->lang->line('company'); ?></label>
                            <input type="text" class="form-control" name="company" id="company" value="<?php echo isset($testimonial->company) ?  $testimonial->company : ''; ?>" placeholder="<?php echo $this->lang->line('company'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="designation"><?php echo $this->lang->line('designation'); ?></label>
                            <input type="text" class="form-control" name="designation" id="designation" value="<?php echo isset($testimonial->designation) ?  $testimonial->designation : ''; ?>" placeholder="<?php echo $this->lang->line('designation'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="sort_by"><?php echo $this->lang->line('sort_by'); ?></label>
                            <input type="number" class="form-control" name="sort_by" id="sort_by" value="<?php echo isset($testimonial->sort_by) ?  $testimonial->sort_by : ''; ?>" placeholder="<?php echo $this->lang->line('sort_by'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="rating"><?php echo $this->lang->line('rating'); ?></label>
                            <input type="number" class="form-control" name="rating" id="rating" value="<?php echo isset($testimonial->rating) ?  $testimonial->rating : ''; ?>" placeholder="<?php echo $this->lang->line('rating'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mt-40">
                            <div class="custom-control custom-checkbox checkbox-primary">
                                <input type="checkbox" class="custom-control-input" name="is_view_on_web" id="is_view_on_web" value="1" <?php echo $testimonial->is_view_on_web ? 'checked' : ''; ?>>
                                <label class="custom-control-label" for="is_view_on_web"><?php echo $this->lang->line('is_view_on_web'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="image"><?php echo $this->lang->line('image'); ?></label>
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                </div>
                                <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                <span class="input-group-append">
                                    <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                        <input type="file" name="image">
                                        <input type="hidden" name="prev_image" id="prev_image" value="<?php echo $testimonial->image; ?>" />
                                    </span>
                                    <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                </span>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="image" class="form-text text-muted">
                                <?php echo form_error('image'); ?>
                            </small>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('message'); ?></span>
                                </div>
                                <textarea class="form-control" name="message" id="message" aria-label="<?php echo $this->lang->line('message'); ?>"><?php echo isset($testimonial->message) ?  $testimonial->message : ''; ?></textarea>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                                <div class="invalid-feedback">
                                    <?php echo $this->lang->line('required_field'); ?>
                                </div>
                                <small id="message" class="form-text text-muted">
                                    <?php echo form_error('message'); ?>
                                </small>
                            </div>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('bn_message'); ?></span>
                                </div>
                                <textarea class="form-control" name="bn_message" id="bn_message" aria-label="<?php echo $this->lang->line('bn_message'); ?>"><?php echo isset($testimonial->bn_message) ?  $testimonial->bn_message : ''; ?></textarea>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" name="id" value="<?php echo $testimonial->id; ?>">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('frontend/testimonial'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('update'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->