<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('frontend'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Row -->
    <div class="row">
        <!-- col-xl-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(ADD, 'frontend', 'frontend')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-desktop font-30 mr-10"></i>
                            <?php echo $this->lang->line('manage'); ?> <?php echo $this->lang->line('section'); ?>
                        </h6>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('frontend/section'), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="news"><?php echo $this->lang->line('news'); ?></label>
                            <textarea rows="5" class="form-control" name="news" id="news" placeholder="<?php echo $this->lang->line('news'); ?>"><?php echo isset($section->news) ?  $section->news : ''; ?></textarea>
                        </div>
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="bn_news"><?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('news'); ?></label>
                            <textarea rows="5" class="form-control" name="bn_news" id="bn_news" placeholder="<?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('news'); ?>"><?php echo isset($section->bn_news) ?  $section->bn_news : ''; ?></textarea>
                        </div>
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="doctor"><?php echo $this->lang->line('doctor'); ?></label>
                            <textarea rows="5" class="form-control" name="doctor" id="doctor" placeholder="<?php echo $this->lang->line('doctor'); ?>"><?php echo isset($section->doctor) ?  $section->doctor : ''; ?></textarea>
                        </div>
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="bn_doctor"><?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('doctor'); ?></label>
                            <textarea rows="5" class="form-control" name="bn_doctor" id="bn_doctor" placeholder="<?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('doctor'); ?>"><?php echo isset($section->bn_doctor) ?  $section->bn_doctor : ''; ?></textarea>
                        </div>
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="department"><?php echo $this->lang->line('department'); ?></label>
                            <textarea rows="5" class="form-control" name="department" id="department" placeholder="<?php echo $this->lang->line('department'); ?>"><?php echo isset($section->department) ?  $section->department : ''; ?></textarea>
                        </div>
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="bn_department"><?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('department'); ?></label>
                            <textarea rows="5" class="form-control" name="bn_department" id="bn_department" placeholder="<?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('department'); ?>"><?php echo isset($section->bn_department) ?  $section->bn_department : ''; ?></textarea>
                        </div>
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="photo"><?php echo $this->lang->line('photo'); ?></label>
                            <textarea rows="5" class="form-control" name="photo" id="photo" placeholder="<?php echo $this->lang->line('photo'); ?>"><?php echo isset($section->photo) ?  $section->photo : ''; ?></textarea>
                        </div>
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="bn_photo"><?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('photo'); ?></label>
                            <textarea rows="5" class="form-control" name="bn_photo" id="bn_photo" placeholder="<?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('photo'); ?>"><?php echo isset($section->bn_photo) ?  $section->bn_photo : ''; ?></textarea>
                        </div>
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="video"><?php echo $this->lang->line('video'); ?></label>
                            <textarea rows="5" class="form-control" name="video" id="video" placeholder="<?php echo $this->lang->line('video'); ?>"><?php echo isset($section->video) ?  $section->video : ''; ?></textarea>
                        </div>
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="bn_video"><?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('video'); ?></label>
                            <textarea rows="5" class="form-control" name="bn_video" id="bn_video" placeholder="<?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('video'); ?>"><?php echo isset($section->bn_video) ?  $section->bn_video : ''; ?></textarea>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('frontend'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo isset($section) & !empty($section) ? $this->lang->line('update') : $this->lang->line('submit'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->