<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('history'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('history'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-xl-12 -->
        <div class="col-lg-12">
            <div class="row">
                <!-- col-lg-12 -->
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <?php echo form_open_multipart(site_url('followup/history'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                            <div class="form-row">
                                <div class="col-md-3 mb-10">
                                    <label for="keyword"><?php echo $this->lang->line('keyword'); ?></label>
                                    <input type="text" class="form-control" name="keyword" id="keyword" value="<?php echo isset($keyword) ?  $keyword : ''; ?>" placeholder="<?php echo $this->lang->line('keyword'); ?>">
                                </div>
                                <div class="col-md-3 mb-10">
                                    <label for="create_date"><?php echo $this->lang->line('create'); ?> <?php echo $this->lang->line('date'); ?></label>
                                    <input type="text" class="form-control" name="create_date" id="create_date" value="<?php echo isset($create_date) ?  $create_date : ''; ?>" placeholder="<?php echo $this->lang->line('create'); ?> <?php echo $this->lang->line('date'); ?>">
                                </div>
                                <div class="col-md-3 mb-10">
                                    <label for="followup_date"><?php echo $this->lang->line('followup'); ?> <?php echo $this->lang->line('date'); ?></label>
                                    <input type="text" class="form-control" name="followup_date" id="followup_date" value="<?php echo isset($followup_date) ?  $followup_date : ''; ?>" placeholder="<?php echo $this->lang->line('followup'); ?> <?php echo $this->lang->line('date'); ?>">
                                </div>
                                <div class="col-md-3 mb-10">
                                    <label for="status"><?php echo $this->lang->line('status'); ?></label>
                                    <select class="form-control custom-select" name="status" id="status">
                                        <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('status'); ?></option>
                                        <option value="1" <?php echo isset($status) && $status == 1 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('active'); ?></option>
                                        <option value="2" <?php echo isset($status) && $status == 2 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('in_active'); ?></option>
                                    </select>
                                </div>
                                <div class="col-md-2 mb-10">
                                    <label for="gender"><?php echo $this->lang->line('gender'); ?></label>
                                    <select class="form-control custom-select" name="gender" id="gender">
                                        <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('gender'); ?></option>
                                        <?php $genders = get_genders(); ?>
                                        <?php foreach ($genders as $key => $value) { ?>
                                            <option value="<?php echo $key; ?>" <?php echo isset($gender) && $gender == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="col-md-4 mb-10">
                                    <label for="category_id"><?php echo $this->lang->line('category'); ?></label>
                                    <select class="form-control custom-select select2" name="category_id" id="category_id">
                                        <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('category'); ?></option>
                                        <?php foreach ($categories as $obj) { ?>
                                            <option value="<?php echo $obj->id; ?>" <?php echo isset($category_id) && $category_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->day; ?>]</option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="col-md-4 mb-10">
                                    <label for="created_by"><?php echo $this->lang->line('created_by'); ?></label>
                                    <select class="form-control custom-select select2" name="created_by" id="created_by">
                                        <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                        <?php foreach ($employees as $obj) { ?>
                                            <option value="<?php echo $obj->user_id; ?>" <?php echo isset($created_by) && $created_by == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                                </div>
                            </div>
                            <?php echo form_close(); ?>
                        </div>
                    </div>
                </div>
                <!-- col-xl-12 -->
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between">
                            <?php if (has_permission(VIEW, 'followup', 'patient')) { ?>
                                <h6 class="card-header d-flex align-items-center">
                                    <i class="fa fa-calendar font-30 mr-10"></i>
                                    <?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('history'); ?>
                                </h6>
                            <?php } ?>
                        </div>
                        <div class="card-body">
                            <div class="table-wrap">
                                <div class="table-responsive">
                                    <table class="table table-sm mb-0">
                                        <thead>
                                            <tr>
                                                <th><?php echo $this->lang->line('sl_no'); ?></th>
                                                <th><?php echo $this->lang->line('patient'); ?></th>
                                                <th><?php echo $this->lang->line('patient_id'); ?></th>
                                                <th><?php echo $this->lang->line('mobile'); ?></th>
                                                <th><?php echo $this->lang->line('address'); ?></th>
                                                <th><?php echo $this->lang->line('category'); ?></th>
                                                <th><?php echo $this->lang->line('create'); ?></th>
                                                <th><?php echo $this->lang->line('followup'); ?></th>
                                                <th><?php echo $this->lang->line('note'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if (isset($patients) && !empty($patients)) { ?>
                                                <?php foreach ($patients as $obj) { ?>
                                                    <tr>
                                                        <td><?php echo $sl_count; ?></td>
                                                        <td>
                                                            <ul class="list-group list-group-flush">
                                                                <li class="list-group-item border-0 p-0">
                                                                    <div class="media align-items-center">
                                                                        <div class="d-flex media-img-wrap mr-10">
                                                                            <div class="avatar avatar-sm">
                                                                                <?php if ($obj->gender == 'male') { ?>
                                                                                    <img src="<?php echo IMG_URL; ?>male.png" alt="male" class="avatar-img rounded-circle">
                                                                                <?php } else { ?>
                                                                                    <img src="<?php echo IMG_URL; ?>female.png" alt="female" class="avatar-img rounded-circle">
                                                                                <?php }  ?>
                                                                            </div>
                                                                        </div>
                                                                        <div class="media-body">
                                                                            <span class="d-block font-15 text-primary text-capitalize text-truncate mw-150p">
                                                                                <?php echo $obj->patient; ?>
                                                                            </span>
                                                                            <span class="d-block text-dark text-capitalize text-truncate mw-150p">
                                                                                <?php echo $this->lang->line($obj->gender); ?>
                                                                            </span>
                                                                            <span class="d-block font-13 text-danger text-truncate mw-150p">
                                                                                <?php echo get_age($obj->dob); ?>
                                                                            </span>
                                                                        </div>
                                                                    </div>
                                                                </li>
                                                            </ul>
                                                        </td>
                                                        <td><?php echo $obj->patient_unique_id; ?></td>
                                                        <td><?php echo $obj->phone; ?></td>
                                                        <td><?php echo $obj->address; ?></td>
                                                        <td>
                                                            <ul class="list-group list-group-flush">
                                                                <li class="list-group-item border-0 p-0">
                                                                    <div class="media align-items-center">
                                                                        <div class="media-body">
                                                                            <span class="d-block font-15 text-primary text-capitalize text-truncate mw-150p">
                                                                                <?php echo $obj->followup_category; ?>
                                                                            </span>
                                                                            <span class="d-block font-13 text-danger text-truncate mw-150p">
                                                                                <?php echo $obj->day; ?>D
                                                                            </span>
                                                                        </div>
                                                                    </div>
                                                                </li>
                                                            </ul>
                                                        </td>
                                                        <td><?php echo date('d M, Y', strtotime($obj->create_date)); ?></td>
                                                        <td><?php echo date('d M, Y', strtotime($obj->followup_date)); ?></td>
                                                        <td><?php echo $obj->note; ?></td>
                                                    </tr>
                                                    <?php $sl_count++; ?>
                                                <?php } ?>
                                            <?php } else { ?>
                                                <tr class="text-center">
                                                    <td colspan="9"><?php echo $this->lang->line('no_data_found'); ?></td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <!-- Card Footer -->
                        <?php if ($this->pagination->create_links()) { ?>
                            <div class="card-footer justify-content-end">
                                <?php echo $this->pagination->create_links(); ?>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div><!-- /Row -->
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
    $('#create_date, #followup_date').daterangepicker({
        startDate: moment(),
        endDate: moment(),
        autoUpdateInput: false,
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Tomorrow': [moment().subtract(-1, 'days'), moment().subtract(-1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Year': [moment().startOf('year'), moment().endOf('year')],
            'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        }
    });

    $('#create_date, #followup_date').on('apply.daterangepicker', function(ev, picker) {
        $(this).val(picker.startDate.format('YYYY/MM/DD') + ' - ' + picker.endDate.format('YYYY/MM/DD'));
    });

    $('#create_date, #followup_date').on('cancel.daterangepicker', function(ev, picker) {
        $(this).val('');
    });
</script>