<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************History.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : History
 * @description     : Manage history.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class History extends MY_Controller
{

    public $data = array();

    function __construct()
    {
        parent::__construct();
        $this->load->model('History_Model', 'history', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "History List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index()
    {

        check_permission(VIEW);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $create_date = $this->input->get('create_date');
            if (isset($create_date) && !empty($create_date)) {
                $exp = explode('-', $create_date);
                $create_form_date = date('Y-m-d', strtotime($exp[0]));
                $create_to_date = date('Y-m-d', strtotime($exp[1]));
            } else {
                $create_form_date = null;
                $create_to_date = null;
            }

            $followup_date = $this->input->get('followup_date');
            if (isset($followup_date) && !empty($followup_date)) {
                $exp1 = explode('-', $followup_date);
                $followup_form_date = date('Y-m-d', strtotime($exp1[0]));
                $followup_to_date = date('Y-m-d', strtotime($exp1[1]));
            } else {
                $followup_form_date = null;
                $followup_to_date = null;
            }

            $status = $this->input->get('status');
            $gender = $this->input->get('gender');
            $category_id = $this->input->get('category_id');
            $created_by = $this->input->get('created_by');

            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = site_url('followup/history/?keyword=' . $keyword . '&create_date=' . $create_date . '&followup_date=' . $followup_date . '&status=' . $status . '&gender=' . $gender . '&category_id=' . $category_id . '&created_by=' . $created_by);
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }
            $config['total_rows'] = $this->history->get_history_list($config['per_page'], $offset, $keyword, $create_form_date, $create_to_date, $followup_form_date, $followup_to_date, $status, $gender, $category_id, $created_by, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['patients'] = $this->history->get_history_list($config['per_page'], $offset, $keyword, $create_form_date, $create_to_date, $followup_form_date, $followup_to_date, $status, $gender, $category_id, $created_by, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));

            $this->data['keyword'] = $keyword;
            $this->data['create_date'] = $create_date;
            $this->data['followup_date'] = $followup_date;
            $this->data['status'] = $status;
            $this->data['gender'] = $gender;
            $this->data['category_id'] = $category_id;
            $this->data['created_by'] = $created_by;
        } else {
            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = current_url();
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->history->get_history_list($config['per_page'], $offset, null, null, null, null, null, null, null, null, null, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['patients'] = $this->history->get_history_list($config['per_page'], $offset, null, null, null, null, null, null, null, null, null, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        }

        $this->data['employees'] = $this->history->get_employee_list();
        $this->data['categories'] = $this->history->get_list('followup_categories', array('status' => 1), '', '', '', 'sort_by', 'ASC');
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('history') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('history/index', $this->data);
    }
}
