<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('vd'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage'); ?> <?php echo $this->lang->line('vd'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('doctor/vd'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-3 mb-10">
                            <label for="keyword"><?php echo $this->lang->line('keyword'); ?></label>
                            <input type="text" class="form-control" name="keyword" id="keyword" value="<?php echo isset($keyword) ?  $keyword : ''; ?>" placeholder="<?php echo $this->lang->line('keyword'); ?>">
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="marketing_id"><?php echo $this->lang->line('marketing'); ?></label>
                            <select class="form-control custom-select select2" name="marketing_id" id="marketing_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('marketing'); ?></option>
                                <?php foreach ($marketings as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($marketing_id) && $marketing_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="department_id"><?php echo $this->lang->line('department'); ?></label>
                            <select class="form-control custom-select select2" name="department_id" id="department_id" onchange="get_designation(this.value)">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('department'); ?></option>
                                <?php foreach ($departments as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($department_id) && $department_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="designation_id"><?php echo $this->lang->line('designation'); ?></label>
                            <select class="form-control custom-select select2" name="designation_id" id="designation_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('designation'); ?></option>
                                <?php foreach ($designations as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($designation_id) && $designation_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'doctor', 'vd')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-user-md font-30 mr-10"></i>
                            <?php echo $this->lang->line('vd'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>

                    <?php if (has_permission(ADD, 'doctor', 'vd')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('doctor/vd/add'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-plus font-12 mr-5"></i>
                                <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('vd'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th><?php echo $this->lang->line('name'); ?></th>
                                        <th><?php echo $this->lang->line('designation'); ?></th>
                                        <th><?php echo $this->lang->line('address'); ?></th>
                                        <th><?php echo $this->lang->line('phone'); ?></th>
                                        <th><?php echo $this->lang->line('marketing'); ?></th>
                                        <th><?php echo $this->lang->line('created_by'); ?></th>
                                        <th><?php echo $this->lang->line('status'); ?></th>
                                        <th class="w-15"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($vds) && !empty($vds)) { ?>
                                        <?php foreach ($vds as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl_count; ?></td>
                                                <td><?php echo $obj->name; ?></td>
                                                <td><?php echo $obj->designation; ?></td>
                                                <td><?php echo $obj->present_address; ?></td>
                                                <td><?php echo $obj->phone; ?></td>
                                                <td><?php echo $obj->marketing; ?></td>
                                                <td><?php echo $obj->created_by; ?></td>
                                                <td><?php echo $obj->status ? '<span class="badge badge-success">' .  $this->lang->line('active') . '</span>' : '<span class="badge badge-danger">' .  $this->lang->line('in_active') . '</span>'; ?></td>
                                                <td>
                                                    <?php if (has_permission(VIEW, 'doctor', 'vd')) { ?>
                                                        <button class="btn btn-xs btn-info" type="button" onclick="get_view_modal(<?php echo $obj->user_id; ?>);" data-toggle="modal" data-target=".viewModalCenter"><i class="fa fa-eye"></i></button>
                                                    <?php } ?>
                                                    <?php if (has_permission(EDIT, 'doctor', 'vd')) { ?>
                                                        <a class="btn btn-xs btn-success" href="<?php echo site_url('doctor/vd/edit/' . $obj->user_id); ?>"><i class="fa fa-pencil-square-o"></i></a>
                                                    <?php } ?>
                                                    <?php if (has_permission(DELETE, 'doctor', 'vd')) { ?>
                                                        <a class="btn btn-xs btn-danger" href="<?php echo site_url('doctor/vd/delete/' . $obj->id); ?>" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');"> <i class="fa fa-trash text-white"></i></a>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                        <?php $sl_count++;
                                        } ?>
                                    <?php } else { ?>
                                        <tr class="text-center">
                                            <td colspan="9"><?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<div class="modal fade viewModalCenter" tabindex="-1" role="dialog" aria-labelledby="viewModalCenter" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-gradient-primary">
                <h5 class="modal-title text-white"><?php echo $this->lang->line('vd'); ?> <?php echo $this->lang->line('info'); ?></h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body modal_data bg-gradient-secondary"></div>
        </div>
    </div>
</div>

<script type="text/javascript">
    function get_view_modal(user_id) {
        $('.modal_data').html('<p style="padding: 20px;"><p style="padding: 20px;text-align:center;"><img src="<?php echo IMG_URL; ?>loader.gif" /></p>');
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('doctor/vd/get_single_vd'); ?>",
            data: {
                user_id: user_id
            },
            success: function(response) {
                if (response) {
                    $('.modal_data').html(response);
                }
            }
        });
    }
</script>