<!DOCTYPE html>
<html>

<head>
    <title>Schedule</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            /* page-break-after: always; */
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content {
            border-collapse: collapse;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 14px;
            font-weight: bold;
        }

        .table_content tbody td {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #222;
            font-size: 14px;
        }

        .footer {
            margin-top: 100px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->
            <h1 align="center" style="margin-bottom: 0;">
                <?php if ($type == 1) { ?>
                    ডাক্তারের সময়সূচী
                <?php } else { ?>
                    Doctor's Schedule
                <?php } ?>
                <p style="text-align: center; font-size: 13px; margin: 0;">
                    <?php if ($type == 1) { ?>
                        <?php if ($doctor_id && $form_date < $to_date) { ?>
                            <?php echo en2bn(date('d-m-Y', strtotime($form_date))); ?> হতে
                            <?php echo en2bn(date('d-m-Y', strtotime($to_date))); ?>
                        <?php } else { ?>
                            <?php echo en2bn(date('d-m-Y', strtotime($form_date))); ?><br>
                            <?php echo en2bnWeek(strtolower(date('l', strtotime($form_date)))); ?>
                        <?php } ?>
                    <?php } else { ?>
                        <?php if ($doctor_id && $form_date < $to_date) { ?>
                            <?php echo date('d-m-Y', strtotime($form_date)); ?> To
                            <?php echo date('d-m-Y', strtotime($to_date)); ?>
                        <?php } else { ?>
                            <?php echo date('d-m-Y', strtotime($form_date)); ?><br>
                            <?php echo date('l', strtotime($form_date)); ?>
                        <?php } ?>
                    <?php } ?>
                </p>
            </h1>
            <div class="info_table">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <?php if ($type == 1) { ?>
                                    <?php if ($doctor_id) { ?>
                                        ডাক্তারঃ <?php echo $doctor->bn_name; ?>, <?php echo $doctor->specialist; ?>
                                    <?php } else { ?>
                                        ডাক্তারঃ সব
                                    <?php }  ?>
                                <?php } else { ?>
                                    <?php if ($doctor_id) { ?>
                                        Doctor: <?php echo $doctor->name; ?>, <?php echo $doctor->specialist; ?>
                                    <?php } else { ?>
                                        Doctor: All
                                    <?php }  ?>
                                <?php } ?>
                            </td>
                            <td width="30%" align="right">
                                <?php if ($type == 1) { ?>
                                    প্রিন্ট টাইমঃ <?php echo en2bn(date('d/m/Y h:ia')); ?>
                                <?php } else { ?>
                                    Print Time: <?php echo date('d/m/Y h:ia'); ?>
                                <?php } ?>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <?php $slots = get_schedule_slot(); ?>
            <!-- Content Start-->
            <div class="content">
                <table class="table table_content">
                    <thead>
                        <?php if ($type == 1) { ?>
                            <tr>
                                <th width="6%">ক্রমিক নং</th>
                                <?php if ($doctor_id && $form_date < $to_date) { ?>
                                    <th width="10%">তারিখ</th>
                                <?php } else { ?>
                                    <th width="25%">ডাক্তার নাম</th>
                                <?php } ?>
                                <?php if ($slot) { ?>
                                    <th><?php echo $this->lang->line($slot); ?></th>
                                <?php } else { ?>
                                    <?php foreach ($slots as $key => $value) { ?>
                                        <th width="13%"><?php echo $key == 'afternoon' ? 'বিকাল' : en2bnSlot($key); ?></th>
                                    <?php } ?>
                                <?php } ?>
                                <th width="10%">মন্তব্য</th>
                                <th width="10%">স্বাক্ষর</th>
                            </tr>
                        <?php } else { ?>
                            <tr>
                                <th width="6%">#SL No</th>
                                <?php if ($doctor_id && $form_date < $to_date) { ?>
                                    <th width="10%">Date</th>
                                <?php } else { ?>
                                    <th width="25%">Doctor's Name</th>
                                <?php } ?>
                                <?php if ($slot) { ?>
                                    <th><?php echo $this->lang->line($slot); ?></th>
                                <?php } else { ?>
                                    <?php foreach ($slots as $key => $value) { ?>
                                        <th width="13%"><?php echo $this->lang->line($key); ?></th>
                                    <?php } ?>
                                <?php } ?>
                                <th width="10%">Remark</th>
                                <th width="10%">Signature</th>
                            </tr>
                        <?php } ?>
                    </thead>
                    <tbody>
                        <?php $count = 1;
                        if (isset($schedules) && !empty($schedules)) { ?>
                            <?php foreach ($schedules as $obj) { ?>
                                <tr>
                                    <td><?php echo $type == 1 ? en2bn($count++) : $count++; ?></td>
                                    <?php if ($doctor_id && $form_date < $to_date) { ?>
                                        <td>
                                            <?php if ($type == '1') {
                                                echo $obj->date ? en2bn(date('d-m-Y', strtotime($obj->date))) : '';
                                            } else {
                                                echo $obj->date ? date('d-m-Y', strtotime($obj->date)) : '';
                                            }
                                            ?>
                                            <br>
                                            <?php if ($type == '1') {
                                                echo $obj->date ? en2bnWeek(strtolower(date('l', strtotime($obj->date)))) : '';
                                            } else {
                                                echo $obj->date ? date('l', strtotime($obj->date)) : '';
                                            } ?>
                                        </td>
                                    <?php } else { ?>
                                        <td style="font-weight: bold;"><?php echo $type == '1' ? $obj->doctor_bn : $obj->doctor; ?></td>
                                    <?php } ?>
                                    <?php if ($slot) { ?>
                                        <td>
                                            <?php echo isset($obj->start_time) && !empty($obj->start_time) ? date('h:ia', strtotime($obj->start_time)) : ''; ?>
                                            <?php echo isset($obj->end_time) && !empty($obj->end_time) ? ' - ' . date('h:ia', strtotime($obj->end_time)) : ''; ?>
                                        </td>
                                    <?php } else { ?>
                                        <?php foreach ($slots as $key => $value) {
                                            $time = $this->schedule->get_single('doctor_schedules', array('slot' => $key, 'doctor_id' => $doctor_id ? $doctor_id : $obj->doctor_id, 'date' => $doctor_id ? $obj->date : $form_date, 'status' => 1));
                                        ?>
                                            <td align="center">
                                                <?php if ($time) { ?>
                                                    <?php if ($type == 1) { ?>
                                                        <?php echo isset($time->start_time) && !empty($time->start_time) ? en2bn(date('h:ia', strtotime($time->start_time))) : ''; ?>
                                                        <?php echo isset($time->end_time) && !empty($time->end_time) ? ' - ' . en2bn(date('h:ia', strtotime($time->end_time))) : ''; ?>
                                                    <?php } else { ?>
                                                        <?php echo isset($time->start_time) && !empty($time->start_time) ? date('h:ia', strtotime($time->start_time)) : ''; ?>
                                                        <?php echo isset($time->end_time) && !empty($time->end_time) ? ' - ' . date('h:ia', strtotime($time->end_time)) : ''; ?>
                                                    <?php }  ?>
                                                <?php } else { ?>
                                                    --
                                                <?php } ?>
                                            </td>
                                        <?php } ?>
                                    <?php } ?>
                                    <td><?php echo $obj->remark; ?></td>
                                    <td></td>
                                </tr>
                            <?php } ?>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
            <!-- Content End -->
            <!-- Footer -->
            <div class="footer">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <p style="margin-left: 10%;">
                                    <b>Prepared By:</b>
                                    <?php echo $this->session->userdata('name'); ?>
                                </p>
                            </td>
                            <td width="30%" align="center">
                                <p style="border-top: 1px dashed red; width: 30%; margin: 5px auto;"></p>
                                <b>Signature</b>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>

</html>