<!DOCTYPE html>
<html>

<head>
    <title>Print Payment History</title>

    <style>
        body {
            font-family: monospace;
            font-size: 14px;
        }

        .page {
            width: 60%;
            margin: 0 auto;
        }

        @page {
            size: A4;
            margin: 0;
        }

        @media print {

            html,
            body {
                font-family: Arial, Helvetica, sans-serif;
            }

            .page {
                width: 60%;
                margin: 0 auto;
                border: initial;
                border-radius: initial;
                min-height: initial;
                box-shadow: initial;
                background: initial;
                page-break-after: always;
            }
        }

        .patient_copy {
            display: block;
            margin-top: 100px;
            min-height: 600px;
            position: relative;
        }

        .title {
            width: 80%;
            font-size: 14px;
            font-weight: bold;
            border: 1px solid #333;
            padding: 5px;
            font-family: monospace;
            text-transform: uppercase;
            letter-spacing: 2px;
            border-radius: 3px;
            text-align: center;
            margin: 3px auto;
        }

        .paid {
            width: 25%;
            margin: 30px auto 0 auto;
            text-align: center;
            font-size: 25px;
            font-weight: bold;
            background: #eee;
            border: 1px solid #000;
            padding: 3px 10px;
            font-family: monospace;
            text-transform: uppercase;
            letter-spacing: 5px;
            border-radius: 3px;
        }

        .table {
            font-size: 14px;
            width: 100%;
            border-collapse: collapse;
          	border: 1px solid #000;
        }

        .patient_table {
            width: 100%;
            text-align: left;
            border-collapse: collapse;
            margin-top: 5px;
        }

        .patient_table tbody td {
            color: #000;
            padding: 2px;
            vertical-align: top;
            border: none;
        }

        /* test_table */
        .test_table {
            margin-top: 10px;
            width: 100%;
            text-align: left;
            border-collapse: collapse;
            border: 1px solid #000;
        }

        .test_table tbody td {
            color: #000;
            padding: 1px 4px;
            vertical-align: top;
            border-top: 1px solid #000;
            font-size: 13px;
        }

        /*  payment_info*/
        .payment_table {
            font-size: 14px;
            width: 100%;
            text-align: left;
        }

        .payment_table tbody td {
            vertical-align: top;
            border: 0;
        }

        .powered_by {
            writing-mode: vertical-lr;
            -webkit-transform: rotate(180deg);
            -moz-transform: rotate(180deg);
            font-size: 8px;
            font-family: 'Times New Roman', Times, serif;
            position: absolute;
            left: -15px;
            top: 80px;
            color: #000;
        }

        .table .top-header thead,
        tbody th,
        td {
            border: 0;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="patient_copy">
            <table class="table">
            <tr>
                <td rowspan="3" width="20%" style="margin-bottom:10px">
                    <?php if($this->global_setting->brand_logo){ ?>
                        <img width="80" valign="middle" align="center" src="<?php echo UPLOAD_PATH; ?>logo/<?php echo $this->global_setting->brand_logo; ?>">
                    <?php } else { ?>
                        <img width="80" valign="middle" align="center" src="<?php echo IMG_URL; ?>logo.png">
                    <?php } ?>
                </td>
                <td width="80%" align="center"><h1 style="margin: 0px; padding:0; font-size: 25px;"><?php echo $this->global_setting->brand_title; ?></h1></td>
            </tr>
            <tr>
                <td align="center"><p style="margin: 0px; padding: 0; font-size: 14px;"><?php echo $this->global_setting->address; ?></p></td>
            </tr>
            <tr>
                 <td align="center"><p style="margin: 0; font-size: 14px;">Phone: <?php echo $this->global_setting->phone; ?></p></td>
            </tr>
        </table>
          <table style="border: none; margin-top: 10px;" class="table">
          	<tr>
              <td style="width: 25%;">
                <img align="left" src="<?php echo site_url('opd/set_barcode/' . $patient->patient_unique_id); ?>" alt="" height="30" width="80%">
              </td>
              <td>
              	<div class="title">Patient Copy</div>
              </td>
              <td style="width: 25%;">
              	<img align="right" src="<?php echo site_url('opd/set_barcode/' . $patient->patient_unique_id); ?>" alt="" height="30" width="80%">
              </td>            
            </tr>
          </table>
             

            <!-- Patient Info Start-->
            <table class="table patient_table">
              <tr>
                    <td style="width: 45%;">
                        <span>Name :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo $patient->patient; ?></span>
                    </td>
                	<td style="width: 55%;">
                        <span>Patient ID :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo $patient->patient_unique_id; ?></span>
                    </td>
                </tr>  
              <tr>
                  <td style="width: 40%;">
                        <span>Age :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo get_age($patient->dob); ?></span>
                    </td>
                    <td style="width: 60%;">
                        <span>Bill No :</span>
                        <span><?php echo $patient->custom_invoice_id; ?></span>
                    </td>
                </tr>
                <tr>
                    <td style="width: 40%;">
                        <span>Gender :</span>
                        <span style="text-transform: capitalize; font-weight: bold;"><?php echo $this->lang->line($patient->gender); ?></span>
                    </td>
                    <td style="width: 60%;">
                        <span>Registered on :</span>
                        <span><?php echo date('d/m/Y h:i A', strtotime($patient->bill_date)); ?></span>
                    </td>
                </tr>
              	<tr>                   
                    <td style="width: 40%;">
                        <span>Contact No :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo $patient->phone; ?></span>
                    </td>
                    <td style="width: 60%;">
                          <span>Date :</span>
                          <span><?php echo date('d/m/Y h:i A', strtotime($patient->bill_date)); ?></span>
                  </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <span>Ref. By :</span>
                        <span style="font-size:12px; text-transform: uppercase; font-weight: bold;">
                            <?php
                            if ($patient->self == 1) {
                                echo 'Self';
                            } elseif ($patient->ref_dr_id == NULL) {
                                echo $patient->ref_dr_name;
                            } else {
                                echo $patient->refdr . ', ' . $patient->specialist;
                            }
                            ?>
                        </span>
                    </td>
                </tr>
            </table>
            <!-- Patient Info End-->

            <?php if (isset($invoice_payments) & !empty($invoice_payments)) { ?>
                <table class="test_table">
                    <thead>
                        <tr>
                            <td width="15%" align="left"><b>SL. No</b></td>
                            <td width="30%" align="left"><b>Collect By</b></td>
                            <td width="15%" align="left"><b>Pay Via</b></td>
                            <td width="25%" align="left"><b>Payment Date</b></td>
                            <td width="15%" align="right"><b>Amount</b></td>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $count = 1; ?>
                        <?php foreach ($invoice_payments as $obj) { ?>
                            <tr>
                                <td width="15%" align="left"><?php echo $count++; ?></td>
                                <td width="30%" align="left"><?php echo $obj->created_by; ?></td>
                                <td width="10%" align="left">Cash</td>
                                <td width="30%" align="right"><?php echo date('d/m/Y h:i A', strtotime($obj->payment_date)); ?></td>
                                <td width="15%" align="right"><?php echo $obj->amount; ?></td>
                            </tr>
                        <?php } ?>
                        <tr>
                            <td colspan="4" align="right">Sub Total</td>
                            <td align="right"><?php echo $invoice->total_bill; ?></td>
                        </tr>
                        <tr>
                            <td colspan="4" align="right">Discount</td>
                            <td align="right"><?php echo $invoice->discount; ?></td>
                        </tr>
                        <tr>
                            <td colspan="4" align="right">Net Payable</td>
                            <td align="right"><?php echo $invoice->net_payable; ?></td>
                        </tr>
                        <tr>
                            <td colspan="4" align="right">Advanced Amount</td>
                            <td align="right"><?php echo $invoice->advanced; ?></td>
                        </tr>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th colspan="4" align="right" style="font-size:14px;">Due Amount</th>
                            <th align="right" style="font-size:14px;"><?php echo $invoice->due_amount; ?></th>
                        </tr>
                    </tfoot>
                </table>
            <?php } ?>
        </div>
    </div>
</body>

</html>