<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Attendance_Model extends MY_Model
{

    function __construct()
    {
        parent::__construct();
    }

    public function get_employee_list()
    {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') != SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, PATHOLOGIST, RADIOLOGIST, NURSE, RECEPTIONIST, STAFF, MARKETING, PHARMACIST));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_attendance_list($limit, $offset, $shift_id, $type, $attendance_status, $form_date, $to_date, $user_id, $department_id, $designation_id, $keyword, $count)
    {
        $this->db->select('A.*, E.name, S.name as shift, S.in_time, S.out_time');
        $this->db->from('attendances AS A');
        $this->db->join('shifts AS S', 'S.id = A.shift_id', 'left');
        $this->db->join('employees AS E', 'E.user_id = A.user_id', 'left');
        $this->db->join('departments AS DP', 'DP.id = E.department_id', 'left');
        $this->db->join('designations AS D', 'D.id = E.designation_id', 'left');
        if ($shift_id) {
            $this->db->where('A.shift_id', $shift_id);
        }
        if ($type == 'manual') {
            $this->db->where('A.is_manual', 1);
        }
        if ($type == 'machine') {
            $this->db->where('A.is_manual', 0);
        }
        if ($type == 'card') {
            $this->db->where('A.punch_type', 'card');
        }
        if ($type == 'finger') {
            $this->db->where('A.punch_type', 'finger');
        }
        if ($type == 'face') {
            $this->db->where('A.punch_type', 'face');
        }
        if ($attendance_status) {
            $this->db->where('A.attendance_status', $attendance_status);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(A.date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($user_id) {
            $this->db->where('A.user_id', $user_id);
        }
        if ($department_id) {
            $this->db->where('E.department_id', $department_id);
        }
        if ($designation_id) {
            $this->db->where('E.designation_id', $designation_id);
        }
        if ($keyword) {
            $this->db->like('E.phone', $keyword, 'both');
            $this->db->or_like('E.name', $keyword, 'both');
        }
        $this->db->order_by('A.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }


    public function get_single_attendance($id)
    {
        $this->db->select('A.*, S.name as shift, E.name, E.phone, DP.name as department, D.name as designation, U.device_id, C.name as created_by, M.name as modified_by');
        $this->db->from('attendances AS A');
        $this->db->join('shifts AS S', 'S.id = A.shift_id', 'left');
        $this->db->join('employees AS E', 'E.user_id = A.user_id', 'left');
        $this->db->join('departments AS DP', 'DP.id = E.department_id', 'left');
        $this->db->join('designations AS D', 'D.id = E.designation_id', 'left');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = A.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = A.modified_by', 'left');
        $this->db->where('A.id', $id);
        return $this->db->get()->row();
    }

    public function get_attendance_employee_list($department_id, $designation_id, $user_id, $shift_id)
    {
        $this->db->select('E.*, U.device_id, D.name as designation, S.name as shift, S.in_time, S.out_time');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->join('designations AS D', 'D.id = E.designation_id', 'left');
        $this->db->join('shifts AS S', 'S.id = E.shift_id', 'left');
        if ($department_id) {
            $this->db->where('E.department_id', $department_id);
        }
        if ($designation_id) {
            $this->db->where('E.designation_id', $designation_id);
        }
        if ($user_id) {
            $this->db->where('E.user_id', $user_id);
        }
        if ($shift_id) {
            $this->db->where('E.shift_id', $shift_id);
        }
        $this->db->where('E.employee_type', 'staff');
        $this->db->where('E.status', 1);
        $this->db->order_by('U.device_id', 'ASC');
        return $this->db->get()->result();
    }
}
