<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Logs.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Logs
 * @description     : Manage all kind of logs of the system.  
 * @author          : South Bangla IT Zone Team 	
 * @url             : https://hms.sbitzone.com/      
 * @support         : rabibd.it@gmail.com	
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Logs extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Logs_Model', 'logs', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Logs Listing" user interface                 
     *                        
     * @param           : null
     * @return          : null 
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        if ($_GET && $this->input->get('date')) {
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $user_id = $this->input->get('user_id');
            $keyword = trim($this->input->get('keyword'));

            $this->data['logs'] = $this->logs->get_attendance_logs_list($form_date, $to_date);
            $this->data['date'] = $date;
            $this->data['user_id'] = $user_id;
            $this->data['keyword'] = $keyword;
        }

        $this->data['employees'] = $this->logs->get_employee_list();
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('manage') . ' ' . $this->lang->line('logs') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('logs/index', $this->data);
    }
}
