<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Import.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Import
 * @description     : Manage all kind of import of the system.  
 * @author          : South Bangla IT Zone Team 	
 * @url             : https://hms.sbitzone.com/      
 * @support         : rabibd.it@gmail.com	
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Import extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Import_Model', 'import', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Import Listing" user interface                 
     *                        
     * @param           : null
     * @return          : null 
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('manage') . ' ' . $this->lang->line('import') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('import/index', $this->data);
    }
}
