<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class News_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_employee_list() {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') == SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(SUPER_ADMIN, ADMIN, ACCOUNTANT, RECEPTIONIST));
        } else {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, RECEPTIONIST));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_news_list($limit, $offset, $keyword, $form_date, $to_date, $created_by, $count) {
        $this->db->select('N.*');
        $this->db->from('news AS N');
        if ($keyword) {
            $this->db->like('N.title', $keyword, 'both');
            $this->db->or_like('N.description', $keyword, 'both');
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(N.date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($created_by) {
            $this->db->where('N.created_by', $created_by);
        }
        $this->db->order_by('N.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_single_news($id) {
        $this->db->select('N.*, C.name as created_by, M.name as modified_by');
        $this->db->from('news AS N');
        $this->db->join('employees AS C', 'C.user_id = N.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = N.modified_by', 'left');
        $this->db->where('N.id', $id);
        return $this->db->get()->row();
    }
}
