<!DOCTYPE html>
<html>

<head>
    <title>Print Bill</title>

    <style>
        body {
            font-family: monospace;
            font-size: 12px;
        }

        .page {
            width: 60%;
            margin: 0 auto;
        }

        @page {
            size: A4;
            margin: 0;
        }

        @media print {

            html,
            body {
                font-family: Arial, Helvetica, sans-serif;
            }

            .page {
                width: 60%;
                margin: 0 auto;
                border: initial;
                border-radius: initial;
                min-height: initial;
                box-shadow: initial;
                background: initial;
                /*page-break-after: always;*/
            }
        }

        .header {
            width: 100%;
            display: inline-block;
          	margin-top: 5px;
        }

        .header img {
            width: 80px;
        }

        .header h1 {
            margin: 0;
            padding: 0;
            text-transform: uppercase;
            font-size: 25px;
        }

        .header p {
            margin: 0;
            padding: 0;
        }

        .header .title {
            margin-top: 10px;
            margin-bottom: 10px;
            text-align: center;
        }

        .header .title span {
            background-color: #000;
            color: #fff;
            border: 1px solid #000;
            border-radius: 5px;
            font-family: monospace;
            font-size: 16px;
            font-weight: bold;
            padding: 5px 10px;
            text-transform: uppercase;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info {
            margin-bottom: 20px;
        }

        .info tbody td {
            color: #000;
            vertical-align: middle;
            font-weight: bold;
            padding: 3px 0;
            font-size: 12px;
        }

        .details thead th {
            color: #000;
            padding: 1px;
            vertical-align: middle;
            border: 1px solid #000;
            width: max-content;
            font-size: 10px;
        }

        .details tbody td {
            color: #000;
            padding: 1px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 10px;
        }

        .details tfoot td {
            color: #000;
            padding: 1px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 10px;
        }


        .summary {
            width: 50%;
            margin: 20px auto;
            float: right;
        }

        .summary tbody td {
            color: #000;
            padding: 3px;
            vertical-align: middle;
            border: 1px solid #000;
            font-weight: bold;
            text-align: left;
            font-size: 10px;
        }
        .sign {
            width: 100%;
            margin-top: 30px;
        }
    </style>
</head>

<body>
    <div class="page">
      	<img style="margin-top: 100px;" src="<?php echo IMG_URL; ?>bill_head.png" alt="h" width="100%">
        <div class="header">
            <table class="table">
                <tbody>
                    <tr>
                        <td>
                            <div class="title" align="center">
                                <span>IPD Payment Voucher</span>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        <!-- Header End -->
        <div class="body">
            <table class="table info">
                <tbody>
                    <tr>
                        <td colspan="2" align="left">
                            Payment Invoice ID: <?php echo $patient->custom_invoice_id; ?>
                        </td>
                        <td colspan="2" align="right" style="font-weight: normal;">
                            Print Time: <?php echo date('M d, Y h:i A'); ?>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            Patient Name: <?php echo $patient->patient_name; ?>
                        </td>
                      	<td>
                            Patient ID: <?php echo $patient->patient_unique_id; ?>
                        </td>
                        
                        <td align="right">
                            Payment Date: <?php echo date('d M, Y h:ia', strtotime($patient->date)); ?>
                        </td>
                    </tr>
                    <tr>
                    <td colspan="3">
                        <b>Ref. By:</b>
                        <?php echo $patient->reference; ?>
                    </td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            Address: <?php echo $patient->address; ?>
                        </td>
                        <td colspan="2" align="right">
                            Prepared By: <?php echo $patient->created_by; ?>
                        </td>
                    </tr>
                </tbody>
            </table>

            <!-- Datails -->
            <table class="table details">
                <tbody>
                    <tr>
                        <td><b>IPD Payable Amount:</b></td>
                        <td><?php echo number_format($patient->payable_amount, 2); ?></td>
                    </tr>
                </tbody>
            </table>
            <table class="sign">
                <tr>
                    <td width="30%">Signature</td>
                    <td width="70%">Mobile:</td>
                </tr>
            </table>
        </div>
    </div>
</body>

</html>
