<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Payment.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Payment
 * @description     : Manage all kind of paymnet transaction by integrated payment gateway.  
 * @author          : South Bangla IT Zone Team 	
 * @url             : https://hms.sbitzone.com/      
 * @support         : rabibd.it@gmail.com	
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Payment extends My_Controller {

    public $data = array();
    function __construct() {
        parent::__construct();
        $this->load->model('Payment_Model', 'payment', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Payment" user interface                 
     *                    with specific invoice data   
     * @param           : $invoice_id integer value
     * @return          : null 
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        if ($_GET) {
            $search = $this->input->get('search');
            $exp = explode('-', $search);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['billings'] = $this->billing->get_billing_list($form_date, $to_date, $doctor_id, $reference_id, $created_by);
            $this->data['search'] = $search;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['doctors'] = $this->payment->get_doctor_list();
        $this->data['references'] = $this->payment->get_list('employees', array('status' => 1));
        $this->data['employees'] = $this->payment->get_list('employees', array('status' => 1));

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('manage_payment') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('payment/index', $this->data);
    }

    /*****************Function opd**********************************
     * @type            : Function
     * @function name   : opd
     * @description     : Load "Opd Payment" user interface                 
     *                    with specific invoice data   
     * @param           : $invoice_id integer value
     * @return          : null 
     * ********************************************************** */
    public function opd() {

        check_permission(ADD);

        if (isset($_GET) && !empty($this->input->get('date'))) {

            $keyword = trim($this->input->get('keyword'));
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = site_url('accounting/payment/opd/?keyword=' . $keyword . '&date=' . $date . '&doctor_id=' . $doctor_id . '&reference_id=' . $reference_id . '&created_by=' . $created_by);
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->payment->get_opd_invoice_list($config['per_page'], $offset, $keyword, $form_date, $to_date, $doctor_id, $reference_id, $created_by, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['opds'] = $this->payment->get_opd_invoice_list($config['per_page'], $offset, $keyword, $form_date, $to_date, $doctor_id, $reference_id, $created_by, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));


            $this->data['keyword'] = $keyword;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        } else {
            $form_date = date('Y-m-d');
            $to_date = date('Y-m-d');
            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = current_url();
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->payment->get_opd_invoice_list($config['per_page'], $offset, null, $form_date, $to_date, null, null, null, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['opds'] = $this->payment->get_opd_invoice_list($config['per_page'], $offset, null, $form_date, $to_date, null, null, null, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        }


        $this->data['doctors'] = $this->payment->get_doctor_list();
        $this->data['references'] = $this->payment->get_list('employees', array('status' => 1));
        $this->data['employees'] = $this->payment->get_employee_list();

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('opd') . ' ' . $this->lang->line('payment') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('payment/opd/index', $this->data);
    }

    /*****************Function get_single_opd**********************************
     * @type            : Function
     * @function name   : get_single_opd
     * @description     : Load "get_single_opd" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function get_single_opd($id) {
        $opd = $this->payment->get_single('opd_patients', array('id' =>  $id));
        echo json_encode($opd);
    }

    /*****************Function addOpdPayment**********************************
     * @type            : Function
     * @function name   : addOpdPayment
     * @description     : Load "addOpdPayment" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function addOpdPayment() {
        if ($_POST) {
            $data['patient_id'] = $this->input->post('patient_id');
            $data['invoice_id'] = $this->input->post('invoice_id');
            $data['invoice_type'] = 'opd';
            $data['commission_user_id'] = $this->input->post('commission_user_id');

            $payment = $this->payment->get_single('payments', array('invoice_id' => $data['invoice_id'], 'commission_user_id' => $data['commission_user_id'], 'invoice_type' => 'opd'));

            if (($payment)) {
                $data['payable_amount'] =  $payment->payable_amount + $this->input->post('payable_amount');
                $data['due_amount'] =  $payment->due_amount - $this->input->post('payable_amount');
                if ($payment->commission_amount <= $data['payable_amount']) {
                    $data['paid_status'] = 'paid';
                } else {
                    $data['paid_status'] = 'unpaid';
                }
            } else {
                $data['commission_amount'] = $this->input->post('commission_amount');
                $data['payable_amount'] = $this->input->post('payable_amount');
                $data['due_amount'] = '0';
                $data['paid_status'] = 'paid';
            }
            $data['payment_status'] = 'complete';
            $data['date'] = $this->input->post('date') ? date('Y-m-d H:i:s', strtotime($this->input->post('date'))) : NULL;
            $data['note'] = $this->input->post('note');

            if (isset($payment)) {
                $data['modified_at'] = date('Y-m-d H:i:s');
                $data['modified_by'] = logged_in_user_id();
                $updated_id = $this->payment->update('payments', $data, array('invoice_id' => $payment->invoice_id, 'commission_user_id' => $payment->commission_user_id, 'invoice_type' => 'opd'));

                create_log('Has been updated a payment : ' . $data['invoice_id']);
                $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('update_success'));
            } else {
                $data['custom_invoice_id'] = get_custom_id('payments', 'INV-', date('Y'), date('m'));
                $data['status'] = 1;
                $data['created_at'] = date('Y-m-d H:i:s');
                $data['created_by'] = logged_in_user_id();
                $insert_id =  $this->payment->insert('payments', $data);

                create_log('Has been created a payment : ' . $data['invoice_id']);
                $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('insert_success'));
            }

            $payment_details = array(
                'invoice_id' => $this->input->post('invoice_id'),
                'payment_id' => isset($payment->id) ? $payment->id : $insert_id,
                'amount' => $this->input->post('payable_amount'),
                'payment_date' => $this->input->post('date') ? date('Y-m-d H:i:s', strtotime($this->input->post('date'))) : NULL,
                'note' => $this->input->post('note'),
                'status' => 1,
                'created_at' => date('Y-m-d H:i:s'),
                'created_by' => logged_in_user_id()
            );
            // Payment Details Data
            $this->payment->insert('payment_details', $payment_details);
        } else {
            $msg = array(
                'payable_amount' => form_error('payable_amount'),
            );
            $array = array('status' => 'failed', 'error' => $msg, 'message' => '');
        }
        echo json_encode($array);
    }

    /*     * ***************Function get_single_opd_payment_view**********************************
     * @type            : Function
     * @function name   : get_single_opd_payment_view
     * @description     : "Load single payment view information" from database                  
     *                    to the user interface   
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_single_opd_payment_view() {
        $id = $this->input->post('id');
        $this->data['payment'] = $this->payment->get_single_opd_payment($id);
        echo $this->load->view('payment/opd/view', $this->data);
    }

    /*****************Function opd_print**********************************
     * @type            : Function
     * @function name   : opd_print
     * @description     : Load "print" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function opd_print() {
        $this->load->library('Numbertowords');
        $this->data['patient'] = $this->payment->get_single_opd_payment($this->input->post('id'));
        $this->load->view('payment/opd/print', $this->data);
    }

    /*****************Function investigation**********************************
     * @type            : Function
     * @function name   : investigation
     * @description     : Load "Investigation Payment" user interface                 
     *                    with specific invoice data   
     * @param           : $invoice_id integer value
     * @return          : null 
     * ********************************************************** */
    public function investigation() {

        check_permission(ADD);

        if (isset($_GET) && $this->input->get('type') === 'multiple' && $this->input->get('status') === 'unpaid' && $this->input->get('reference_id') > 0) {
            $type = $this->input->get('type');
            $status = $this->input->get('status');
            $keyword = trim($this->input->get('keyword'));
            $date = $this->input->get('date');
            if (isset($date) && !empty($date)) {
                $exp = explode('-', $date);
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[1]));
            } else {
                $form_date = null;
                $to_date = null;
            }
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');
            $this->data['multi_investigations'] = $this->payment->get_multi_investigation_invoice_list($status, $form_date, $to_date, $reference_id, $doctor_id, $created_by, $keyword);

            $this->data['type'] = $type;
            $this->data['status'] = $status;
            $this->data['keyword'] = $keyword;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        } elseif (isset($_GET) && $this->input->get('status')) {
            $type = $this->input->get('type');
            $status = $this->input->get('status');
            $keyword = trim($this->input->get('keyword'));
            $date = $this->input->get('date');
            if (isset($date) && !empty($date)) {
                $exp = explode('-', $date);
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[1]));
            } else {
                $form_date = null;
                $to_date = null;
            }
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = site_url('accounting/payment/investigation/?status=' . $status . '&date=' . $date . '&reference_id=' . $reference_id . '&doctor_id=' . $doctor_id  . '&created_by=' . $created_by . '&keyword=' . $keyword);
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->payment->get_investigation_invoice_list($config['per_page'], $offset, $status, $form_date, $to_date, $reference_id, $doctor_id, $created_by, $keyword, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['investigations'] = $this->payment->get_investigation_invoice_list($config['per_page'], $offset, $status, $form_date, $to_date, $reference_id, $doctor_id, $created_by, $keyword, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));


            $this->data['type'] = $type;
            $this->data['status'] = $status;
            $this->data['keyword'] = $keyword;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        } else {
            $form_date = date('Y-m-d');
            $to_date = date('Y-m-d');
            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = current_url();
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->payment->get_investigation_invoice_list($config['per_page'], $offset, null, $form_date, $to_date, null, null, null, null, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['investigations'] = $this->payment->get_investigation_invoice_list($config['per_page'], $offset, null, $form_date, $to_date, null, null, null, null, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
            $this->data['type'] = 'single';
        }

        $this->data['doctors'] = $this->payment->get_doctor_list();
        $this->data['references'] = $this->payment->get_investigation_reference_list();
        $this->data['employees'] = $this->payment->get_employee_list();

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('investigation') . ' ' . $this->lang->line('payment') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('payment/investigation/index', $this->data);
    }

    /*****************Function get_single_investigation**********************************
     * @type            : Function
     * @function name   : get_single_investigation
     * @description     : Load "get_single_investigation" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function get_single_investigation($id) {
        $investigation = $this->payment->get_single('invoices', array('id' =>  $id));
        echo json_encode($investigation);
    }

    /*****************Function addInvestigationPayment**********************************
     * @type            : Function
     * @function name   : addInvestigationPayment
     * @description     : Load "addInvestigationPayment" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function addInvestigationPayment() {

        if ($_POST) {
            $invoice = $this->payment->get_single('invoices', array('id' => $this->input->post('invoice_id')));
            $data['custom_invoice_id'] = get_datewise_payment_custom_invoice_id('payments', 'investigation', date('Y-m-d'), 'PINV-', date('Y'), date('m'), date('d'));
            $data['patient_id'] = $invoice->patient_id;
            $data['invoice_id'] = $this->input->post('invoice_id');
            $data['invoice_type'] = 'investigation';
            $data['commission_user_id'] = $invoice->commission_user_id;
            $data['commission_amount'] = $invoice->commission_amount;
            $data['payable_amount'] = $this->input->post('payable_amount');
            $data['due_amount'] = '0';
            $data['paid_status'] = 'paid';
            $data['payment_status'] = 'complete';
            $data['date'] = $this->input->post('date') ? date('Y-m-d H:i:s', strtotime($this->input->post('date'))) : NULL;
            $data['note'] = $this->input->post('note');
            $data['status'] = 1;
            $data['created_at'] = date('Y-m-d H:i:s');
            $data['created_by'] = logged_in_user_id();
            $insert_id =  $this->payment->insert('payments', $data);
            $payment_details = array(
                'invoice_id' => $this->input->post('invoice_id'),
                'payment_id' => $insert_id,
                'amount' => $this->input->post('payable_amount'),
                'payment_date' => $this->input->post('date') ? date('Y-m-d H:i:s', strtotime($this->input->post('date'))) : NULL,
                'note' => $this->input->post('note'),
                'status' => 1,
                'created_at' => date('Y-m-d H:i:s'),
                'created_by' => logged_in_user_id()
            );
            // Payment Details Data
            $this->payment->insert('payment_details', $payment_details);

            // Send SMS
            if (has_permission(ADD, 'accounting', 'investigation_payment_sms')) {
                send_sms('investigation_payment_sms', $insert_id);
            }

            //Invoice Table Update Data
            $this->payment->update('invoices', array('commission_payment' => 'paid'), array('id' => $data['invoice_id']));
            $commission = $this->payment->get_single('employees', array('user_id' => $data['commission_user_id']));
            create_log('Has been created a single investigation commission payment for invoice : ' . $data['custom_invoice_id'] . ' commission name: ' . $commission->name);
            $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('insert_success'));
        } else {
            $msg = array(
                'payable_amount' => form_error('payable_amount'),
            );
            $array = array('status' => 'failed', 'error' => $msg, 'message' => '');
        }
        echo json_encode($array);
    }

    /*     * ***************Function get_single_investigation_payment_view**********************************
     * @type            : Function
     * @function name   : get_single_investigation_payment_view
     * @description     : "Load single payment view information" from database                  
     *                    to the user interface   
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_single_investigation_payment_view() {
        $id = $this->input->post('id');
        $this->data['payment'] = $this->payment->get_single_investigation_payment($id);
        echo $this->load->view('payment/investigation/view', $this->data);
    }

    /*****************Function investigation_print**********************************
     * @type            : Function
     * @function name   : investigation_print
     * @description     : Load "print" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function investigation_print() {
        $this->load->library('Numbertowords');
        $this->data['patient'] = $this->payment->get_single_investigation_payment($this->input->post('id'));
        $this->data['departments'] = $this->payment->get_list('diagnostic_departments', array('status' => 1), '', '', '', 'sort_by', 'ASC');
        $this->load->view('payment/investigation/print', $this->data);
    }

    /*****************Function investigation_draft_print**********************************
     * @type            : Function
     * @function name   : investigation_draft_print
     * @description     : Load "print" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function investigation_draft_print() {
        $this->load->library('Numbertowords');
        $this->data['patient'] = $this->payment->get_single_investigation_draft_print($this->input->post('id'));
        $this->data['departments'] = $this->payment->get_list('diagnostic_departments', array('status' => 1), '', '', '', 'sort_by', 'ASC');
        $this->load->view('payment/investigation/draft-print', $this->data);
    }

    public function multi_investigation_payment() {

        $this->db->trans_start();
        if (!empty($_POST['invoices'])) {
            $total_commission_amount = 0;
            $total_commission_payable_amount = 0;
            foreach ($_POST['invoices'] as $key => $value) {
                $invoice = $this->payment->get_single('invoices', array('id' => $value));
                $total_commission_amount += $invoice->commission_amount;
                $total_commission_payable_amount += $_POST['payable_amount'][$value];
            }
            // Payment Invoice Data
            $payment_invoice = array(
                'custom_invoice_id' => get_datewise_payment_custom_invoice_id('payment_invoices', 'investigation', date('Y-m-d'), 'INV-', date('Y'), date('m'), date('d')),
                'commission_id' => $this->input->post('reference_id'),
                'invoice_type' => 'investigation',
                'date' => date('Y-m-d H:i:s'),
                'total_commission_amount' => $total_commission_amount,
                'total_payable_commission' => $total_commission_payable_amount,
                'paid_status' => 'paid',
                'payment_status' => 'complete',
                'status' => 1,
                'created_at' => date('Y-m-d H:i:s'),
                'created_by' => logged_in_user_id()
            );
            $payment_id =  $this->payment->insert('payment_invoices', $payment_invoice);
            foreach ($_POST['invoices'] as $key => $value) {
                $invoice = $this->payment->get_single('invoices', array('id' => $value));
                $data['custom_invoice_id'] = get_datewise_payment_custom_invoice_id('payments', 'investigation', date('Y-m-d'), 'PINV-', date('Y'), date('m'), date('d'));
                $data['patient_id'] = $invoice->patient_id;
                $data['invoice_id'] = $value;
                $data['payment_id'] = $payment_id;
                $data['invoice_type'] = 'investigation';
                $data['commission_user_id'] = $invoice->commission_user_id;
                $data['commission_amount'] = $invoice->commission_amount;


                $data['payable_amount'] = $_POST['payable_amount'][$value];
                $data['due_amount'] = 0;
                $data['paid_status'] = 'paid';
                $data['payment_status'] = 'complete';
                $data['date'] = date('Y-m-d H:i:s');
                $data['status'] = 1;
                $data['created_at'] = date('Y-m-d H:i:s');
                $data['created_by'] = logged_in_user_id();
                $insert_id = $this->payment->insert('payments', $data);

                // Payment Details Data
                $payment_details = array(
                    'invoice_id' => $value,
                    'payment_id' => $insert_id,
                    'amount' => $data['payable_amount'],
                    'payment_date' => date('Y-m-d H:i:s'),
                    'status' => 1,
                    'created_at' => date('Y-m-d H:i:s'),
                    'created_by' => logged_in_user_id()
                );
                $this->payment->insert('payment_details', $payment_details);

                //Invoice Table Update Data
                $this->payment->update('invoices', array('commission_payment' => 'paid'), array('id' => $value));

                // Send SMS
                if (has_permission(ADD, 'accounting', 'investigation_payment_sms')) {
                    send_sms('investigation_payment_sms', $insert_id);
                }

                $commission = $this->payment->get_single('employees', array('user_id' => $data['commission_user_id']));
                create_log('Has been created a multiple investigation commission payment for invoice : ' . $data['custom_invoice_id'] . ' commission name: ' . $commission->name);
            }
        }
        $this->db->trans_complete();
        if ($insert_id) {
            success($this->lang->line('insert_success'));
            redirect('accounting/payment/investigation_success/' . $payment_id);
        } else {
            error($this->lang->line('insert_failed'));
            redirect('accounting/payment/investigation');
        }
    }

    public function investigation_success($id) {
        $this->data['invoices'] = $this->payment->get_multi_investigation_payment_invoice($id);
        $this->data['payemnt_id'] = $id;
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('investigation') . ' ' . $this->lang->line('payment') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('payment/investigation/success', $this->data);
    }

    public function multi_investigation_print() {
        $id = $this->input->post('id');
        $this->load->library('Numbertowords');
        $this->data['reference'] = $this->payment->get_multi_patient_reference($id);
        $this->data['invoices'] = $this->payment->get_multi_investigation_payment_invoice($id);
        $this->data['departments'] = $this->payment->get_list('diagnostic_departments', array('status' => 1), '', '', '', 'sort_by', 'ASC');
        $this->load->view('payment/investigation/multi-print', $this->data);
    }

    public function investigation_payment_sms($id = null) {
        check_permission(VIEW);
        if ($id) {
            send_sms('investigation_payment_sms', $id);
        }
    }


    /*****************Function surgeon**********************************
     * @type            : Function
     * @function name   : surgeon
     * @description     : Load "Surgeon Payment" user interface                 
     *                    with specific invoice data   
     * @param           : $invoice_id integer value
     * @return          : null 
     * ********************************************************** */
    public function surgeon() {

        check_permission(ADD);

        if (isset($_GET) && !empty($this->input->get('date'))) {
            $keyword = trim($this->input->get('keyword'));
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $created_by = $this->input->get('created_by');

            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = site_url('accounting/payment/surgeon/?keyword=' . $keyword . '&date=' . $date . '&doctor_id=' . $doctor_id . '&created_by=' . $created_by);
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->payment->get_surgeon_invoice_list($config['per_page'], $offset, $keyword, $form_date, $to_date, $doctor_id, $created_by, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['surgeons'] = $this->payment->get_surgeon_invoice_list($config['per_page'], $offset, $keyword, $form_date, $to_date, $doctor_id, $created_by, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));


            $this->data['keyword'] = $keyword;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['created_by'] = $created_by;
        } else {
            $form_date = date('Y-m-d');
            $to_date = date('Y-m-d');
            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = current_url();
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->payment->get_surgeon_invoice_list($config['per_page'], $offset, null, $form_date, $to_date, null, null, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['surgeons'] = $this->payment->get_surgeon_invoice_list($config['per_page'], $offset, null, $form_date, $to_date, null, null, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        }

        $this->data['doctors'] = $this->payment->get_doctor_list();
        $this->data['references'] = $this->payment->get_list('employees', array('status' => 1));
        $this->data['employees'] = $this->payment->get_employee_list();

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('surgeon') . ' ' . $this->lang->line('payment') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('payment/surgeon/index', $this->data);
    }

    /*****************Function get_single_surgeon**********************************
     * @type            : Function
     * @function name   : get_single_surgeon
     * @description     : Load "get_single_surgeon" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function get_single_surgeon($id) {
        $surgeon = $this->payment->get_single('ipd_surgeons', array('id' =>  $id));
        echo json_encode($surgeon);
    }

    /*****************Function addSurgeonPayment**********************************
     * @type            : Function
     * @function name   : addSurgeonPayment
     * @description     : Load "addSurgeonPayment" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function addSurgeonPayment() {
        if ($_POST) {
            $data['patient_id'] = $this->input->post('patient_id');
            $data['invoice_id'] = $this->input->post('invoice_id');
            $data['invoice_type'] = 'surgeon';
            $data['commission_user_id'] = $this->input->post('commission_user_id');

            $payment = $this->payment->get_single('payments', array('invoice_id' => $data['invoice_id'], 'commission_user_id' => $data['commission_user_id'], 'invoice_type' => 'surgeon'));

            if (($payment)) {
                $data['payable_amount'] =  $payment->payable_amount + $this->input->post('payable_amount');
                $data['due_amount'] =  $payment->due_amount - $this->input->post('payable_amount');
                if ($payment->commission_amount <= $data['payable_amount']) {
                    $data['paid_status'] = 'paid';
                } else {
                    $data['paid_status'] = 'unpaid';
                }
            } else {
                $data['commission_amount'] = $this->input->post('commission_amount');
                $data['payable_amount'] = $this->input->post('payable_amount');
                $data['due_amount'] = '0';
                $data['paid_status'] = 'paid';
            }
            $data['payment_status'] = 'complete';
            $data['date'] = $this->input->post('date') ? date('Y-m-d H:i:s', strtotime($this->input->post('date'))) : NULL;
            $data['note'] = $this->input->post('note');

            if (isset($payment)) {
                $data['modified_at'] = date('Y-m-d H:i:s');
                $data['modified_by'] = logged_in_user_id();
                $updated_id = $this->payment->update('payments', $data, array('invoice_id' => $payment->invoice_id, 'commission_user_id' => $payment->commission_user_id, 'invoice_type' => 'surgeon'));

                create_log('Has been updated a payment : ' . $data['invoice_id']);
                $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('update_success'));
            } else {
                $data['custom_invoice_id'] = get_custom_id('payments', 'INV-', date('Y'), date('m'));
                $data['status'] = 1;
                $data['created_at'] = date('Y-m-d H:i:s');
                $data['created_by'] = logged_in_user_id();
                $insert_id =  $this->payment->insert('payments', $data);

                create_log('Has been created a payment : ' . $data['invoice_id']);
                $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('insert_success'));
            }

            $payment_details = array(
                'invoice_id' => $this->input->post('invoice_id'),
                'payment_id' => isset($payment->id) ? $payment->id : $insert_id,
                'amount' => $this->input->post('payable_amount'),
                'payment_date' => $this->input->post('date') ? date('Y-m-d H:i:s', strtotime($this->input->post('date'))) : NULL,
                'note' => $this->input->post('note'),
                'status' => 1,
                'created_at' => date('Y-m-d H:i:s'),
                'created_by' => logged_in_user_id()
            );
            // Payment Details Data
            $this->payment->insert('payment_details', $payment_details);
        } else {
            $msg = array(
                'payable_amount' => form_error('payable_amount'),
            );
            $array = array('status' => 'failed', 'error' => $msg, 'message' => '');
        }
        echo json_encode($array);
    }

    /*     * ***************Function get_single_surgeon_payment_view**********************************
     * @type            : Function
     * @function name   : get_single_surgeon_payment_view
     * @description     : "Load single payment view information" from database                  
     *                    to the user interface   
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_single_surgeon_payment_view() {
        $id = $this->input->post('id');
        $this->data['payment'] = $this->payment->get_single_surgeon_payment($id);
        echo $this->load->view('payment/surgeon/view', $this->data);
    }

    /*****************Function surgeon_print**********************************
     * @type            : Function
     * @function name   : surgeon_print
     * @description     : Load "print" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function surgeon_print() {
        $this->load->library('Numbertowords');
        $this->data['patient'] = $this->payment->get_single_surgeon_payment($this->input->post('id'));
        $this->load->view('payment/surgeon/print', $this->data);
    }

    /*****************Function anesthesia**********************************
     * @type            : Function
     * @function name   : anesthesia
     * @description     : Load "Anesthesia Payment" user interface                 
     *                    with specific invoice data   
     * @param           : $invoice_id integer value
     * @return          : null 
     * ********************************************************** */
    public function anesthesia() {

        check_permission(ADD);

        if (isset($_GET) && !empty($this->input->get('date'))) {
            $keyword = trim($this->input->get('keyword'));
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $created_by = $this->input->get('created_by');

            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = site_url('accounting/payment/anesthesia/?keyword=' . $keyword . '&date=' . $date . '&doctor_id=' . $doctor_id . '&created_by=' . $created_by);
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->payment->get_anesthesia_invoice_list($config['per_page'], $offset, $keyword, $form_date, $to_date, $doctor_id, $created_by, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['anesthesias'] = $this->payment->get_anesthesia_invoice_list($config['per_page'], $offset, $keyword, $form_date, $to_date, $doctor_id, $created_by, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));


            $this->data['keyword'] = $keyword;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['created_by'] = $created_by;
        } else {
            $form_date = date('Y-m-d');
            $to_date = date('Y-m-d');
            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = current_url();
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->payment->get_anesthesia_invoice_list($config['per_page'], $offset, null, $form_date, $to_date, null, null, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['anesthesias'] = $this->payment->get_anesthesia_invoice_list($config['per_page'], $offset, null, $form_date, $to_date, null, null, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        }

        $this->data['doctors'] = $this->payment->get_list('anesthetists', array('status' => 1));
        $this->data['references'] = $this->payment->get_list('employees', array('status' => 1));
        $this->data['employees'] = $this->payment->get_employee_list();

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('anesthesia') . ' ' . $this->lang->line('payment') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('payment/anesthesia/index', $this->data);
    }

    /*****************Function get_single_anesthesia**********************************
     * @type            : Function
     * @function name   : get_single_anesthesia
     * @description     : Load "get_single_anesthesia" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function get_single_anesthesia($id) {
        $anesthesia = $this->payment->get_single('ipd_anesthesias', array('id' =>  $id));
        echo json_encode($anesthesia);
    }

    /*****************Function addAnesthesiaPayment**********************************
     * @type            : Function
     * @function name   : addAnesthesiaPayment
     * @description     : Load "addAnesthesiaPayment" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function addAnesthesiaPayment() {
        if ($_POST) {
            $data['patient_id'] = $this->input->post('patient_id');
            $data['invoice_id'] = $this->input->post('invoice_id');
            $data['invoice_type'] = 'anesthesia';
            $data['commission_user_id'] = $this->input->post('commission_user_id');

            $payment = $this->payment->get_single('payments', array('invoice_id' => $data['invoice_id'], 'commission_user_id' => $data['commission_user_id'], 'invoice_type' => 'anesthesia'));

            if (($payment)) {
                $data['payable_amount'] =  $payment->payable_amount + $this->input->post('payable_amount');
                $data['due_amount'] =  $payment->due_amount - $this->input->post('payable_amount');
                if ($payment->commission_amount <= $data['payable_amount']) {
                    $data['paid_status'] = 'paid';
                } else {
                    $data['paid_status'] = 'unpaid';
                }
            } else {
                $data['commission_amount'] = $this->input->post('commission_amount');
                $data['payable_amount'] = $this->input->post('payable_amount');
                $data['due_amount'] = '0';
                $data['paid_status'] = 'paid';
            }
            $data['payment_status'] = 'complete';
            $data['date'] = $this->input->post('date') ? date('Y-m-d H:i:s', strtotime($this->input->post('date'))) : NULL;
            $data['note'] = $this->input->post('note');

            if (isset($payment)) {
                $data['modified_at'] = date('Y-m-d H:i:s');
                $data['modified_by'] = logged_in_user_id();
                $updated_id = $this->payment->update('payments', $data, array('invoice_id' => $payment->invoice_id, 'commission_user_id' => $payment->commission_user_id, 'invoice_type' => 'anesthesia'));

                create_log('Has been updated a payment : ' . $data['invoice_id']);
                $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('update_success'));
            } else {
                $data['custom_invoice_id'] = get_custom_id('payments', 'INV-', date('Y'), date('m'));
                $data['status'] = 1;
                $data['created_at'] = date('Y-m-d H:i:s');
                $data['created_by'] = logged_in_user_id();
                $insert_id =  $this->payment->insert('payments', $data);

                create_log('Has been created a payment : ' . $data['invoice_id']);
                $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('insert_success'));
            }

            $payment_details = array(
                'invoice_id' => $this->input->post('invoice_id'),
                'payment_id' => isset($payment->id) ? $payment->id : $insert_id,
                'amount' => $this->input->post('payable_amount'),
                'payment_date' => $this->input->post('date') ? date('Y-m-d H:i:s', strtotime($this->input->post('date'))) : NULL,
                'note' => $this->input->post('note'),
                'status' => 1,
                'created_at' => date('Y-m-d H:i:s'),
                'created_by' => logged_in_user_id()
            );
            // Payment Details Data
            $this->payment->insert('payment_details', $payment_details);
        } else {
            $msg = array(
                'payable_amount' => form_error('payable_amount'),
            );
            $array = array('status' => 'failed', 'error' => $msg, 'message' => '');
        }
        echo json_encode($array);
    }

    /*     * ***************Function get_single_anesthesia_payment_view**********************************
     * @type            : Function
     * @function name   : get_single_anesthesia_payment_view
     * @description     : "Load single payment view information" from database                  
     *                    to the user interface   
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_single_anesthesia_payment_view() {
        $id = $this->input->post('id');
        $this->data['payment'] = $this->payment->get_single_anesthesia_payment($id);
        echo $this->load->view('payment/anesthesia/view', $this->data);
    }

    /*****************Function anesthesia_print**********************************
     * @type            : Function
     * @function name   : anesthesia_print
     * @description     : Load "print" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function anesthesia_print() {
        $this->load->library('Numbertowords');
        $this->data['patient'] = $this->payment->get_single_anesthesia_payment($this->input->post('id'));
        $this->load->view('payment/anesthesia/print', $this->data);
    }

    /*****************Function assistant**********************************
     * @type            : Function
     * @function name   : assistant
     * @description     : Load "Anesthesia Payment" user interface                 
     *                    with specific invoice data   
     * @param           : $invoice_id integer value
     * @return          : null 
     * ********************************************************** */
    public function assistant() {

        check_permission(ADD);

        if (isset($_GET) && !empty($this->input->get('date'))) {
            $keyword = trim($this->input->get('keyword'));
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $created_by = $this->input->get('created_by');

            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = site_url('accounting/payment/assistant/?keyword=' . $keyword . '&date=' . $date . '&doctor_id=' . $doctor_id . '&created_by=' . $created_by);
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->payment->get_assistant_invoice_list($config['per_page'], $offset, $keyword, $form_date, $to_date, $doctor_id, $created_by, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['assistants'] = $this->payment->get_assistant_invoice_list($config['per_page'], $offset, $keyword, $form_date, $to_date, $doctor_id, $created_by, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));


            $this->data['keyword'] = $keyword;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['created_by'] = $created_by;
        } else {
            $form_date = date('Y-m-d');
            $to_date = date('Y-m-d');
            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = current_url();
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->payment->get_assistant_invoice_list($config['per_page'], $offset, null, $form_date, $to_date, null, null, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['assistants'] = $this->payment->get_assistant_invoice_list($config['per_page'], $offset, null, $form_date, $to_date, null, null, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        }

        $this->data['doctors'] = $this->payment->get_list('assistants', array('status' => 1));
        $this->data['references'] = $this->payment->get_list('employees', array('status' => 1));
        $this->data['employees'] = $this->payment->get_employee_list();

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('assistant') . ' ' . $this->lang->line('payment') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('payment/assistant/index', $this->data);
    }

    /*****************Function get_single_assistant**********************************
     * @type            : Function
     * @function name   : get_single_assistant
     * @description     : Load "get_single_assistant" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function get_single_assistant($id) {
        $assistant = $this->payment->get_single('ipd_assistants', array('id' =>  $id));
        echo json_encode($assistant);
    }

    /*****************Function addAssistantPayment**********************************
     * @type            : Function
     * @function name   : addAssistantPayment
     * @description     : Load "addAssistantPayment" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function addAssistantPayment() {
        if ($_POST) {
            $data['patient_id'] = $this->input->post('patient_id');
            $data['invoice_id'] = $this->input->post('invoice_id');
            $data['invoice_type'] = 'assistant';
            $data['commission_user_id'] = $this->input->post('commission_user_id');

            $payment = $this->payment->get_single('payments', array('invoice_id' => $data['invoice_id'], 'commission_user_id' => $data['commission_user_id'], 'invoice_type' => 'assistant'));

            if (($payment)) {
                $data['payable_amount'] =  $payment->payable_amount + $this->input->post('payable_amount');
                $data['due_amount'] =  $payment->due_amount - $this->input->post('payable_amount');
                if ($payment->commission_amount <= $data['payable_amount']) {
                    $data['paid_status'] = 'paid';
                } else {
                    $data['paid_status'] = 'unpaid';
                }
            } else {
                $data['commission_amount'] = $this->input->post('commission_amount');
                $data['payable_amount'] = $this->input->post('payable_amount');
                $data['due_amount'] = '0';
                $data['paid_status'] = 'paid';
            }
            $data['payment_status'] = 'complete';
            $data['date'] = $this->input->post('date') ? date('Y-m-d H:i:s', strtotime($this->input->post('date'))) : NULL;
            $data['note'] = $this->input->post('note');

            if (isset($payment)) {
                $data['modified_at'] = date('Y-m-d H:i:s');
                $data['modified_by'] = logged_in_user_id();
                $updated_id = $this->payment->update('payments', $data, array('invoice_id' => $payment->invoice_id, 'commission_user_id' => $payment->commission_user_id, 'invoice_type' => 'assistant'));

                create_log('Has been updated a payment : ' . $data['invoice_id']);
                $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('update_success'));
            } else {
                $data['custom_invoice_id'] = get_custom_id('payments', 'INV-', date('Y'), date('m'));
                $data['status'] = 1;
                $data['created_at'] = date('Y-m-d H:i:s');
                $data['created_by'] = logged_in_user_id();
                $insert_id =  $this->payment->insert('payments', $data);

                create_log('Has been created a payment : ' . $data['invoice_id']);
                $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('insert_success'));
            }

            $payment_details = array(
                'invoice_id' => $this->input->post('invoice_id'),
                'payment_id' => isset($payment->id) ? $payment->id : $insert_id,
                'amount' => $this->input->post('payable_amount'),
                'payment_date' => $this->input->post('date') ? date('Y-m-d H:i:s', strtotime($this->input->post('date'))) : NULL,
                'note' => $this->input->post('note'),
                'status' => 1,
                'created_at' => date('Y-m-d H:i:s'),
                'created_by' => logged_in_user_id()
            );
            // Payment Details Data
            $this->payment->insert('payment_details', $payment_details);
        } else {
            $msg = array(
                'payable_amount' => form_error('payable_amount'),
            );
            $array = array('status' => 'failed', 'error' => $msg, 'message' => '');
        }
        echo json_encode($array);
    }

    /*     * ***************Function get_single_assistant_payment_view**********************************
     * @type            : Function
     * @function name   : get_single_assistant_payment_view
     * @description     : "Load single payment view information" from database                  
     *                    to the user interface   
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_single_assistant_payment_view() {
        $id = $this->input->post('id');
        $this->data['payment'] = $this->payment->get_single_assistant_payment($id);
        echo $this->load->view('payment/assistant/view', $this->data);
    }

    /*****************Function assistant_print**********************************
     * @type            : Function
     * @function name   : assistant_print
     * @description     : Load "print" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function assistant_print() {
        $this->load->library('Numbertowords');
        $this->data['patient'] = $this->payment->get_single_assistant_payment($this->input->post('id'));
        $this->load->view('payment/assistant/print', $this->data);
    }
    
    
    /*****************Function ipd**********************************
     * @type            : Function
     * @function name   : ipd
     * @description     : Load "IPD Payment" user interface                 
     *                    with specific invoice data   
     * @param           : $invoice_id integer value
     * @return          : null 
     * ********************************************************** */
    public function ipd() {

        check_permission(ADD);

        if (isset($_GET) && !empty($this->input->get('date'))) {
            $keyword = trim($this->input->get('keyword'));
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $reference_id = $this->input->get('reference_id');
            $doctor_id = $this->input->get('doctor_id');
            $created_by = $this->input->get('created_by');

            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = site_url('accounting/payment/assistant/?keyword=' . $keyword . '&date=' . $date . '&doctor_id=' . $doctor_id . '&reference_id=' . $reference_id . '&created_by=' . $created_by);
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->payment->get_ipd_invoice_list($config['per_page'], $offset, $keyword, $form_date, $to_date, $doctor_id, $reference_id, $created_by, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['ipds'] = $this->payment->get_ipd_invoice_list($config['per_page'], $offset, $keyword, $form_date, $to_date, $doctor_id, $reference_id, $created_by, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));


            $this->data['keyword'] = $keyword;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        } else {
            $form_date = date('Y-m-d');
            $to_date = date('Y-m-d');
            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = current_url();
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->payment->get_ipd_invoice_list($config['per_page'], $offset, null, $form_date, $to_date, null, null, null, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['ipds'] = $this->payment->get_ipd_invoice_list($config['per_page'], $offset, null, $form_date, $to_date, null, null, null, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        }

        $this->data['doctors'] = $this->payment->get_doctor_list();
        $this->data['references'] = $this->payment->get_list('employees', array('status' => 1));
        $this->data['employees'] = $this->payment->get_employee_list();

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('ipd') . ' ' . $this->lang->line('payment') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('payment/ipd/index', $this->data);
    }

    /*****************Function get_single_ipd**********************************
     * @type            : Function
     * @function name   : get_single_ipd
     * @description     : Load "get_single_ipd" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function get_single_ipd($id) {
        $ipd = $this->payment->get_single('ipd_invoices', array('id' =>  $id));
        echo json_encode($ipd);
    }

    /*****************Function addAssistantPayment**********************************
     * @type            : Function
     * @function name   : addAssistantPayment
     * @description     : Load "addAssistantPayment" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function addIpdPayment() {
        if ($_POST) {
            $data['patient_id'] = $this->input->post('patient_id');
            $data['invoice_id'] = $this->input->post('invoice_id');
            $data['invoice_type'] = 'ipd';
            $data['commission_user_id'] = $this->input->post('commission_user_id');

            $payment = $this->payment->get_single('payments', array('invoice_id' => $data['invoice_id'], 'commission_user_id' => $data['commission_user_id'], 'invoice_type' => 'ipd'));

            if (($payment)) {
                $data['payable_amount'] =  $payment->payable_amount + $this->input->post('payable_amount');
                $data['due_amount'] =  $payment->due_amount - $this->input->post('payable_amount');
                if ($payment->commission_amount <= $data['payable_amount']) {
                    $data['paid_status'] = 'paid';
                } else {
                    $data['paid_status'] = 'unpaid';
                }
            } else {
                $data['commission_amount'] = $this->input->post('commission_amount');
                $data['payable_amount'] = $this->input->post('payable_amount');
                $data['due_amount'] = '0';
                $data['paid_status'] = 'paid';
            }
            $data['payment_status'] = 'complete';
            $data['date'] = $this->input->post('date') ? date('Y-m-d H:i:s', strtotime($this->input->post('date'))) : NULL;
            $data['note'] = $this->input->post('note');

            if (isset($payment)) {
                $data['modified_at'] = date('Y-m-d H:i:s');
                $data['modified_by'] = logged_in_user_id();
                $updated_id = $this->payment->update('payments', $data, array('invoice_id' => $payment->invoice_id, 'commission_user_id' => $payment->commission_user_id, 'invoice_type' => 'ipd'));

                create_log('Has been updated a payment : ' . $data['invoice_id']);
                $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('update_success'));
            } else {
                $data['custom_invoice_id'] = get_custom_id('payments', 'INV-', date('Y'), date('m'));
                $data['status'] = 1;
                $data['created_at'] = date('Y-m-d H:i:s');
                $data['created_by'] = logged_in_user_id();
                $insert_id =  $this->payment->insert('payments', $data);

                create_log('Has been created a payment : ' . $data['invoice_id']);
                $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('insert_success'));
            }

            $payment_details = array(
                'invoice_id' => $this->input->post('invoice_id'),
                'payment_id' => isset($payment->id) ? $payment->id : $insert_id,
                'amount' => $this->input->post('payable_amount'),
                'payment_date' => $this->input->post('date') ? date('Y-m-d H:i:s', strtotime($this->input->post('date'))) : NULL,
                'note' => $this->input->post('note'),
                'status' => 1,
                'created_at' => date('Y-m-d H:i:s'),
                'created_by' => logged_in_user_id()
            );
            // Payment Details Data
            $this->payment->insert('payment_details', $payment_details);
        } else {
            $msg = array(
                'payable_amount' => form_error('payable_amount'),
            );
            $array = array('status' => 'failed', 'error' => $msg, 'message' => '');
        }
        echo json_encode($array);
    }

    /*     * ***************Function get_single_ipd_payment_view**********************************
     * @type            : Function
     * @function name   : get_single_ipd_payment_view
     * @description     : "Load single payment view information" from database                  
     *                    to the user interface   
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_single_ipd_payment_view() {
        $id = $this->input->post('id');
        $this->data['payment'] = $this->payment->get_single_ipd_payment($id);
        echo $this->load->view('payment/ipd/view', $this->data);
    }

    /*****************Function ipd_print**********************************
     * @type            : Function
     * @function name   : ipd_print
     * @description     : Load "print" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function ipd_print() {
        $this->load->library('Numbertowords');
        $this->data['patient'] = $this->payment->get_single_ipd_payment($this->input->post('id'));
        $this->load->view('payment/ipd/print', $this->data);
    }
}
