<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

/**
 * Nab Config Class
 *
 * @package        Nab
 * @subpackage    Core Library
 * @category    Config
 * @author        Misael Zapata
 * @link        http://misaelzapata.com
 */
class MY_Config extends CI_Config {

    var $config_path = ''; // Set in the constructor below
    var $database_path = ''; // Set in the constructor below
    var $index_path = ''; // Set in the constructor below
    var $autoload_path = ''; // Set in the constructor below

    /**
     * Constructor
     *
     * @access    public
     * @return    void
     */

    function __construct() {
        parent::__construct();

        $define_path = "";
        if (defined('ENVIRONMENT')) {
            switch (ENVIRONMENT) {
                case 'development':
                    $this->define_path = APPPATH . 'config/development/database' . EXT;
                    break;

                case 'testing':
                case 'production':
                    $this->define_path = APPPATH . 'config/production/database' . EXT;
                    break;

                default:
                    exit('The application environment is not set correctly.');
            }
        }

        $this->config_path = APPPATH . 'config/config' . EXT;
        $this->database_path = $this->define_path;
        $this->autoload_path = APPPATH . 'config/autoload' . EXT;
        $tem_index = getcwd();
        $this->index_path = $tem_index . "/index.php";
    }
}
