<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * ***************Ajax.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Ajax
 * @description     : This class used to handle ajax call from view file 
 *                    of whole application.  
 * @author          : South Bangla IT Zone Team 	
 * @url             : http://hms.sbitzone.com    
 * @support         : rabibd.it@gmail.com	
 * @copyright       : South Bangla IT Zone Team	 	
 * ********************************************************** */

class Ajax extends My_Controller {
    public function __construct() {
        parent::__construct();
        $this->load->model('Ajax_Model', 'ajax', true);
    }

    /**     * *************Function update_user_status**********************************
     * @type            : Function
     * @function name   : update_user_status
     * @description     : this function used to update module status
     * @param           : null
     * @return          : boolean true/false
     * ********************************************************** */
    public function update_user_status() {
        $user_id = $this->input->post('user_id');
        $status = $this->input->post('status');
        if ($this->ajax->update('users', array('status' => $status), array('id' => $user_id))) {
            echo TRUE;
        } else {
            echo FALSE;
        }
    }

    /**     * *************Function update_module_status**********************************
     * @type            : Function
     * @function name   : update_module_status
     * @description     : this function used to update module status
     * @param           : null
     * @return          : boolean true/false
     * ********************************************************** */
    public function update_module_status() {
        $id = $this->input->post('id');
        $status = $this->input->post('status');
        if ($this->ajax->update('modules', array('status' => $status), array('id' => $id))) {
            echo TRUE;
        } else {
            echo FALSE;
        }
    }

    /**     * *************Function update_department_status**********************************
     * @type            : Function
     * @function name   : update_department_status
     * @description     : this function used to update department status
     * @param           : null
     * @return          : boolean true/false
     * ********************************************************** */
    public function update_department_status() {
        $id = $this->input->post('id');
        $status = $this->input->post('status');
        if ($this->ajax->update('departments', array('status' => $status), array('id' => $id))) {
            echo TRUE;
        } else {
            echo FALSE;
        }
    }

    /**     * *************Function update_designation_status**********************************
     * @type            : Function
     * @function name   : update_designation_status
     * @description     : this function used to update designation status
     * @param           : null
     * @return          : boolean true/false
     * ********************************************************** */
    public function update_designation_status() {
        $id = $this->input->post('id');
        $status = $this->input->post('status');
        if ($this->ajax->update('designations', array('status' => $status), array('id' => $id))) {
            echo TRUE;
        } else {
            echo FALSE;
        }
    }

    /*     * ***************Function get_department_by_designation**********************************
     * @type            : Function
     * @function name   : get_department_by_designation
     * @description     : Load "Designation Listing" by ajax call                
     *                    and populate user listing
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_department_by_designation() {
        $department_id = $this->input->post('department_id');
        $designations = $this->ajax->get_list('designations', array('status' => 1, 'department_id' => $department_id), '', '', '', 'sort_by', 'ASC');

        $str = '<option value="">--' . $this->lang->line('select') . '--</option>';
        $select = 'selected="selected"';
        if (!empty($designations)) {
            foreach ($designations as $obj) {
                $selected = isset($designation_id) == $obj->id ? $select : '';
                $str .= '<option value="' . $obj->id . '" ' . $selected . '>' . $obj->name . '</option>';
            }
        }
        echo $str;
    }

    /*     * ***************Function get_charge_type_by_category**********************************
     * @type            : Function
     * @function name   : get_charge_type_by_category
     * @description     : Load "Charge Category Listing" by ajax call                
     *                    and populate user listing
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_charge_type_by_category() {
        $charge_type = $this->input->post('charge_type');
        $category = $this->ajax->get_list('charge_categories', array('status' => 1, 'charge_type' => $charge_type), '', '', '', 'sort_by', 'ASC');

        $str = '<option value="">--' . $this->lang->line('select') . '--</option>';
        $select = 'selected="selected"';
        if (!empty($category)) {
            foreach ($category as $obj) {
                $selected = isset($charge_category) == $obj->id ? $select : '';
                $str .= '<option value="' . $obj->id . '" ' . $selected . '>' . $obj->name . '</option>';
            }
        }
        echo $str;
    }

    /*     * ***************Function get_department_by_diagnostic_group**********************************
     * @type            : Function
     * @function name   : get_department_by_diagnostic_group
     * @description     : Load "Diagnostic Group Listing" by ajax call                
     *                    and populate user listing
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_department_by_diagnostic_group() {
        $department_id = $this->input->post('department_id');
        $groups = $this->ajax->get_list('diagnostic_groups', array('status' => 1, 'department_id' => $department_id), '', '', '', 'sort_by', 'ASC');

        $str = '<option value="">--' . $this->lang->line('select') . '--</option>';
        $select = 'selected="selected"';
        if (!empty($groups)) {
            foreach ($groups as $obj) {
                $selected = isset($group_id) == $obj->id ? $select : '';
                $str .= '<option value="' . $obj->id . '" ' . $selected . '>' . $obj->name . '</option>';
            }
        }
        echo $str;
    }

    /*     * ***************Function get_department_by_diagnostic_test**********************************
     * @type            : Function
     * @function name   : get_department_by_diagnostic_test
     * @description     : Load "Diagnostic Test Listing" by ajax call                
     *                    and populate user listing
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_department_by_diagnostic_test() {
        $department_id = $this->input->post('department_id');
        $tests = $this->ajax->get_list('diagnostic_tests', array('status' => 1, 'department_id' => $department_id), '', '', '', 'sort_by', 'ASC');

        $str = '<option value="">--' . $this->lang->line('select') . '--</option>';
        $select = 'selected="selected"';
        if (!empty($tests)) {
            foreach ($tests as $obj) {
                $selected = isset($test_id) == $obj->id ? $select : '';
                $str .= '<option value="' . $obj->id . '" ' . $selected . '>' . $obj->name . '</option>';
            }
        }
        echo $str;
    }

    /*     * ***************Function get_investagation_by_template**********************************
     * @type            : Function
     * @function name   : get_investagation_by_template
     * @description     : Load "Template Listing" by ajax call                
     *                    and populate user listing
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_investagation_by_template() {
        $investagation_id = $this->input->post('investagation_id');
        $templates = $this->ajax->get_list('diagnostic_templates', array('status' => 1, 'test_id' => $investagation_id), '', '', '', 'id', 'ASC');

        $str = '<option value="">--' . $this->lang->line('select') . '--</option>';
        $select = 'selected="selected"';
        if (!empty($templates)) {
            foreach ($templates as $obj) {
                $selected = isset($template_id) == $obj->id ? $select : '';
                $str .= '<option value="' . $obj->id . '" ' . $selected . '>' . $obj->name . '</option>';
            }
        }
        echo $str;
    }

    /**     * *************Function get_user_by_role**********************************
     * @type            : Function
     * @function name   : get_user_by_role
     * @description     : this function used to manage user role list for user interface
     * @param           : null
     * @return          : $str string value with user role list
     * ********************************************************** */
    public function get_user_by_role() {
        $role_id = $this->input->post('role_id');
        $user_id = $this->input->post('user_id');
        $users = array();
        if ($role_id == SUPER_ADMIN) {
            $this->db->select('E.*');
            $this->db->from('employees AS E');
            $this->db->join('users AS U', 'U.id = E.user_id', 'left');
            $this->db->where('U.role_id', $role_id);
            $this->db->where('U.status', 1);
            $this->db->where('E.status', 1);
            $users = $this->db->get()->result();
        }
        elseif ($role_id == PATIENT) {
            $this->db->select('P.*');
            $this->db->from('patients AS P');
            $this->db->join('users AS U', 'U.id = P.user_id', 'left');
            $this->db->where('U.role_id', $role_id);
            $this->db->where('U.status', 1);
            $this->db->where('P.status', 1);
            $users = $this->db->get()->result();
        } else {
            $this->db->select('E.*');
            $this->db->from('employees AS E');
            $this->db->join('users AS U', 'U.id = E.user_id', 'left');
            $this->db->where('U.role_id', $role_id);
            $this->db->where('U.status', 1);
            $this->db->where('E.status', 1);
            $users = $this->db->get()->result();
        }
        $str = '<option value="">--' . $this->lang->line('select') . '--</option>';

        $select = 'selected="selected"';
        if (!empty($users)) {
            foreach ($users as $obj) {
                $selected = $user_id == $obj->user_id ? $select : '';
                if ($role_id == SUPER_ADMIN) {
                    $str .= '<option value="' . $obj->user_id . '" ' . $selected . '>' . $obj->name . ' [' . $obj->phone . ']</option>';
                } else {
                    $str .= '<option value="' . $obj->user_id . '" ' . $selected . '>' . $obj->name . ' [' . $obj->phone . ']</option>';
                }
            }
        }

        echo $str;
    }

    /*     * **************Function get_tag_by_role**********************************
     * @type            : Function
     * @function name   : get_tag_by_role
     * @description     : this function used to manage user role tag list for user interface   
     * @param           : null 
     * @return          : $str string value with user role tag list 
     * ********************************************************** */

    public function get_tag_by_role() {

        $role_id = $this->input->post('role_id');
        $tags = get_template_tags($role_id);
        $str = '';
        foreach ($tags as $value) {
            $str .= '<span> ' . $value . ' </span>';
        }

        echo $str;
    }

    /*     * ***************Function get_bed_group_by_bed**********************************
     * @type            : Function
     * @function name   : get_bed_group_by_bed
     * @description     : Load "Bed Listing" by ajax call                
     *                    and populate user listing
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_bed_group_by_bed() {
        $bed_group_id = $this->input->post('bed_group_id');
        $beds = $this->ajax->get_list('beds', array('status' => 1, 'is_active' => 0, 'group_id' => $bed_group_id), '', '', '', 'id', 'ASC');

        $str = '<option value="">--' . $this->lang->line('select') . '--</option>';
        $select = 'selected="selected"';
        if (!empty($beds)) {
            foreach ($beds as $obj) {
                $selected = isset($bed_id) == $obj->id ? $select : '';
                $str .= '<option value="' . $obj->id . '" ' . $selected . '>' . $obj->name . '</option>';
            }
        }
        echo $str;
    }

    /*     * ***************Function get_doctor_template**********************************
     * @type            : Function
     * @function name   : get_doctor_template
     * @description     : Load "Template Listing" by ajax call                
     *                    and populate user listing
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_doctor_template() {
        $doctor_id = $this->input->post('doctor_id');
        $templates = $this->ajax->get_list('ultrasonography_templates', array('status' => 1, 'doctor_id' => $doctor_id), '', '', '', 'id', 'ASC');

        $str = '<option value="">--' . $this->lang->line('select') . '--</option>';
        $select = 'selected="selected"';
        if (!empty($templates)) {
            foreach ($templates as $obj) {
                $selected = isset($template_id) == $obj->id ? $select : '';
                $str .= '<option value="' . $obj->id . '" ' . $selected . '>' . $obj->name . '</option>';
            }
        }
        echo $str;
    }

    /*     * ***************Function get_investagation_by_radiology_template**********************************
     * @type            : Function
     * @function name   : get_investagation_by_radiology_template
     * @description     : Load "Template Listing" by ajax call                
     *                    and populate user listing
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_investagation_by_radiology_template() {
        if ($this->session->userdata('role_id') == DOCTOR) {
            $investagation_id = $this->input->post('investagation_id');
            $templates = $this->ajax->get_list('ultrasonography_templates', array('status' => 1, 'doctor_id' => $this->session->userdata('user_id'), 'test_id' => $investagation_id), '', '', '', 'id', 'ASC');
        } else {
            $investagation_id = $this->input->post('investagation_id');
            $templates = $this->ajax->get_list('ultrasonography_templates', array('status' => 1, 'test_id' => $investagation_id), '', '', '', 'id', 'ASC');
        }
        $str = '<option value="">--' . $this->lang->line('select') . '--</option>';
        $select = 'selected="selected"';
        if (!empty($templates)) {
            foreach ($templates as $obj) {
                $selected = isset($template_id) == $obj->id ? $select : '';
                $str .= '<option value="' . $obj->id . '" ' . $selected . '>' . $obj->name . '</option>';
            }
        }
        echo $str;
    }

    /*     * ***************Function get_manufacturer_by_medicine**********************************
     * @type            : Function
     * @function name   : get_manufacturer_by_medicine
     * @description     : Load "Medicine Listing" by ajax call                
     *                    and populate user listing
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_manufacturer_by_medicine() {
        $manufacturer_id = $this->input->post('manufacturer_id');
        $medicines = $this->ajax->get_list('medicines', array('status' => 1, 'manufacturer_id' => $manufacturer_id), '', '', '', 'id', 'ASC');
        $str = '<option value="">--' . $this->lang->line('select') . '--</option>';
        $select = 'selected="selected"';
        if (!empty($medicines)) {
            foreach ($medicines as $obj) {
                $selected = isset($medicine_id) == $obj->id ? $select : '';
                $str .= '<option value="' . $obj->id . '" ' . $selected . '>' . $obj->medicine_name . '</option>';
            }
        }
        echo $str;
    }
    
    /*     * ***************Function get_upazila_by_union**********************************
     * @type            : Function
     * @function name   : get_upazila_by_union
     * @description     : Load "Upazilas Listing" by ajax call                
     *                    and populate user listing
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_upazila_by_union() {
        $upazila_id = $this->input->post('upazila_id');
        $unions = $this->ajax->get_list('unions', array('status' => 1, 'upazila_id' => $upazila_id), '', '', '', 'sort_by', 'ASC');

        $str = '<option value="">--' . $this->lang->line('select') . '--</option>';
        $select = 'selected="selected"';
        if (!empty($unions)) {
            foreach ($unions as $obj) {
                $selected = isset($test_id) == $obj->id ? $select : '';
                $str .= '<option value="' . $obj->id . '" ' . $selected . '>' . $obj->bn_name . '</option>';
            }
        }
        echo $str;
    }
	
	/*     * ***************Function get_union_by_village**********************************
     * @type            : Function
     * @function name   : get_union_by_village
     * @description     : Load "Villages Listing" by ajax call                
     *                    and populate user listing
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_union_by_village() {
        $union_id = $this->input->post('union_id');
        $villages = $this->ajax->get_list('villages', array('status' => 1, 'union_id' => $union_id), '', '', '', 'sort_by', 'ASC');

        $str = '<option value="">--' . $this->lang->line('select') . '--</option>';
        $select = 'selected="selected"';
        if (!empty($villages)) {
            foreach ($villages as $obj) {
                $selected = isset($test_id) == $obj->id ? $select : '';
                $str .= '<option value="' . $obj->id . '" ' . $selected . '>' . $obj->bn_name . '</option>';
            }
        }
        echo $str;
    }
}
